package com.chenyang.druid.sql.ast.expr;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.SQLUtils;
import com.chenyang.druid.sql.ast.SQLDataType;
import com.chenyang.druid.sql.ast.SQLDataTypeImpl;
import com.chenyang.druid.sql.ast.SQLExprImpl;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.Collections;
import java.util.List;

public class SQLJSONExpr extends SQLExprImpl implements SQLValuableExpr {
   public static final SQLDataType DATA_TYPE = new SQLDataTypeImpl("JSON");
   protected String literal;

   public SQLJSONExpr() {
   }

   public SQLJSONExpr(String literal) {
      this.literal = literal;
   }

   public SQLJSONExpr clone() {
      SQLJSONExpr x = new SQLJSONExpr(this.literal);
      return x;
   }

   public String getValue() {
      return this.literal;
   }

   public String getLiteral() {
      return this.literal;
   }

   public void setLiteral(String literal) {
      this.literal = literal;
   }

   public boolean equals(Object o) {
      if (this == o) {
         return true;
      } else if (o != null && this.getClass() == o.getClass()) {
         SQLJSONExpr that = (SQLJSONExpr)o;
         return this.literal != null ? this.literal.equals(that.literal) : that.literal == null;
      } else {
         return false;
      }
   }

   public int hashCode() {
      return this.literal != null ? this.literal.hashCode() : 0;
   }

   protected void accept0(SQLASTVisitor visitor) {
      visitor.visit(this);
      visitor.endVisit(this);
   }

   public String toString() {
      return SQLUtils.toSQLString(this, (DbType)((DbType)null));
   }

   public SQLDataType computeDataType() {
      return DATA_TYPE;
   }

   public List getChildren() {
      return Collections.emptyList();
   }
}
