package com.chenyang.druid.sql.ast.expr;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLExprImpl;
import com.chenyang.druid.sql.ast.SQLReplaceable;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLListExpr extends SQLExprImpl implements SQLReplaceable {
   private final List<SQLExpr> items;

   public SQLListExpr() {
      this.items = new ArrayList();
   }

   public SQLListExpr(SQLExpr... items) {
      this.items = new ArrayList(items.length);

      for(SQLExpr item : items) {
         item.setParent(this);
         this.items.add(item);
      }

   }

   public List<SQLExpr> getItems() {
      return this.items;
   }

   public void addItem(SQLExpr item) {
      if (item != null) {
         item.setParent(this);
      }

      this.items.add(item);
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         for(int i = 0; i < this.items.size(); ++i) {
            SQLExpr item = (SQLExpr)this.items.get(i);
            if (item != null) {
               item.accept(visitor);
            }
         }
      }

      visitor.endVisit(this);
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + this.items.hashCode();
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         SQLListExpr other = (SQLListExpr)obj;
         return this.items.equals(other.items);
      }
   }

   public SQLListExpr clone() {
      SQLListExpr x = new SQLListExpr();

      for(SQLExpr item : this.items) {
         SQLExpr item2 = item.clone();
         item2.setParent(x);
         x.items.add(item2);
      }

      return x;
   }

   public List getChildren() {
      return this.items;
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      for(int i = 0; i < this.items.size(); ++i) {
         if (this.items.get(i) == expr) {
            target.setParent(this);
            this.items.set(i, target);
            return true;
         }
      }

      return false;
   }
}
