package com.chenyang.druid.sql.ast.expr;

import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.Collections;
import java.util.List;

public class SQLRealExpr extends SQLNumericLiteralExpr implements SQLValuableExpr {
   private float value;

   public SQLRealExpr() {
   }

   public SQLRealExpr(float value) {
      this.value = value;
   }

   public SQLRealExpr(String value) {
      this.value = Float.valueOf(value);
   }

   public SQLRealExpr clone() {
      return new SQLRealExpr(this.value);
   }

   public List<SQLObject> getChildren() {
      return Collections.emptyList();
   }

   public Number getNumber() {
      return this.value;
   }

   public Float getValue() {
      return this.value;
   }

   public void setValue(Float value) {
      this.value = value;
   }

   protected void accept0(SQLASTVisitor visitor) {
      visitor.visit(this);
      visitor.endVisit(this);
   }

   public void setValue(float value) {
      this.value = value;
   }

   public boolean equals(Object o) {
      if (this == o) {
         return true;
      } else if (o != null && this.getClass() == o.getClass()) {
         SQLRealExpr that = (SQLRealExpr)o;
         return Float.compare(that.value, this.value) == 0;
      } else {
         return false;
      }
   }

   public int hashCode() {
      return this.value != 0.0F ? Float.floatToIntBits(this.value) : 0;
   }

   public void setNumber(Number number) {
      if (number == null) {
         this.setValue((Float)null);
      } else {
         this.setValue(number.floatValue());
      }
   }
}
