package com.chenyang.druid.sql.ast.expr;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.SQLUtils;
import com.chenyang.druid.sql.ast.SQLDataType;
import com.chenyang.druid.sql.ast.SQLDataTypeImpl;
import com.chenyang.druid.sql.ast.SQLExprImpl;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import com.chenyang.druid.util.MySqlUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class SQLTimestampExpr extends SQLExprImpl implements SQLValuableExpr, SQLLiteralExpr {
   public static final SQLDataType DATA_TYPE = new SQLDataTypeImpl("timestamp");
   protected String literal;
   protected String timeZone;
   protected boolean withTimeZone = false;

   public SQLTimestampExpr() {
   }

   public SQLTimestampExpr(String literal) {
      this.literal = literal;
   }

   public SQLTimestampExpr(Date date) {
      this.setLiteral(date);
   }

   public SQLTimestampExpr(Date date, TimeZone timeZone) {
      this.setLiteral(date, timeZone);
   }

   public SQLTimestampExpr clone() {
      SQLTimestampExpr x = new SQLTimestampExpr();
      x.literal = this.literal;
      x.timeZone = this.timeZone;
      x.withTimeZone = this.withTimeZone;
      return x;
   }

   public Date getDate(TimeZone timeZone) {
      return this.literal != null && this.literal.length() != 0 ? MySqlUtils.parseDate(this.literal, timeZone) : null;
   }

   public boolean addDay(int delta) {
      if (this.literal == null) {
         return false;
      } else {
         SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

         try {
            Date date = format.parse(this.literal);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(5, delta);
            String result_chars = format.format(calendar.getTime());
            this.setLiteral(result_chars);
            return true;
         } catch (ParseException var6) {
            return false;
         }
      }
   }

   public boolean addMonth(int delta) {
      if (this.literal == null) {
         return false;
      } else {
         SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

         try {
            Date date = format.parse(this.literal);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(2, delta);
            String result_chars = format.format(calendar.getTime());
            this.setLiteral(result_chars);
            return true;
         } catch (ParseException var6) {
            return false;
         }
      }
   }

   public boolean addHour(int delta) {
      if (this.literal == null) {
         return false;
      } else {
         SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

         try {
            Date date = format.parse(this.literal);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(11, delta);
            String result_chars = format.format(calendar.getTime());
            this.setLiteral(result_chars);
            return true;
         } catch (ParseException var6) {
            return false;
         }
      }
   }

   public boolean addMiniute(int delta) {
      if (this.literal == null) {
         return false;
      } else {
         SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

         try {
            Date date = format.parse(this.literal);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(12, delta);
            String result_chars = format.format(calendar.getTime());
            this.setLiteral(result_chars);
            return true;
         } catch (ParseException var6) {
            return false;
         }
      }
   }

   public String getValue() {
      return this.literal;
   }

   public String getLiteral() {
      return this.literal;
   }

   public void setLiteral(String literal) {
      this.literal = literal;
   }

   public void setLiteral(Date x) {
      this.setLiteral(x, (TimeZone)null);
   }

   public void setLiteral(Date x, TimeZone timeZone) {
      if (x == null) {
         this.literal = null;
      } else {
         SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
         if (timeZone != null) {
            format.setTimeZone(timeZone);
         }

         this.literal = format.format(x);
      }
   }

   public String getTimeZone() {
      return this.timeZone;
   }

   public void setTimeZone(String timeZone) {
      this.timeZone = timeZone;
   }

   public boolean isWithTimeZone() {
      return this.withTimeZone;
   }

   public void setWithTimeZone(boolean withTimeZone) {
      this.withTimeZone = withTimeZone;
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.literal == null ? 0 : this.literal.hashCode());
      result = 31 * result + (this.timeZone == null ? 0 : this.timeZone.hashCode());
      result = 31 * result + (this.withTimeZone ? 1231 : 1237);
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         SQLTimestampExpr other = (SQLTimestampExpr)obj;
         if (this.literal == null) {
            if (other.literal != null) {
               return false;
            }
         } else if (!this.literal.equals(other.literal)) {
            return false;
         }

         if (this.timeZone == null) {
            if (other.timeZone != null) {
               return false;
            }
         } else if (!this.timeZone.equals(other.timeZone)) {
            return false;
         }

         return this.withTimeZone == other.withTimeZone;
      }
   }

   protected void accept0(SQLASTVisitor visitor) {
      visitor.visit(this);
      visitor.endVisit(this);
   }

   public String toString() {
      return SQLUtils.toSQLString(this, (DbType)((DbType)null));
   }

   public SQLDataType computeDataType() {
      return DATA_TYPE;
   }

   public List getChildren() {
      return Collections.emptyList();
   }

   public static boolean check(String str) {
      int len;
      if (str != null && (len = str.length()) >= 14 && len <= 23) {
         char c0 = str.charAt(0);
         char c1 = str.charAt(1);
         char c2 = str.charAt(2);
         char c3 = str.charAt(3);
         char c4 = str.charAt(4);
         char c5 = str.charAt(5);
         char c6 = str.charAt(6);
         char c7 = str.charAt(7);
         char c8 = str.charAt(8);
         char c9 = str.charAt(9);
         char c10 = str.charAt(10);
         if (c0 < '1' | c0 > '9') {
            return false;
         } else if (c1 < '0' | c1 > '9') {
            return false;
         } else if (c2 < '0' | c2 > '9') {
            return false;
         } else if (c3 < '0' | c3 > '9') {
            return false;
         } else {
            int year = (c0 - 48) * 1000 + (c1 - 48) * 100 + (c2 - 48) * 10 + (c3 - 48);
            if (year < 1000) {
               return false;
            } else if (c4 != '-') {
               return false;
            } else {
               char M0 = 0;
               char M1 = '\u0000';
               char d0 = 0;
               char d1 = '\u0000';
               if (c8 == ' ') {
                  if (c6 != '-') {
                     return false;
                  }

                  M1 = c5;
                  d1 = c7;
               } else if (c9 == ' ') {
                  if (c6 == '-') {
                     M1 = c5;
                     d0 = c7;
                     d1 = c8;
                  } else {
                     if (c7 != '-') {
                        return false;
                     }

                     M0 = c5;
                     M1 = c6;
                     d1 = c8;
                  }
               } else {
                  if (c10 != ' ') {
                     return false;
                  }

                  if (c7 != '-') {
                     return false;
                  }

                  M0 = c5;
                  M1 = c6;
                  d0 = c8;
                  d1 = c9;
               }

               int month;
               if (M0 == 0) {
                  if (M1 < '0' || M1 > '9') {
                     return false;
                  }

                  month = M1 - 48;
               } else {
                  if (M0 != '0' && M0 != '1') {
                     return false;
                  }

                  if (M1 < '0' || M1 > '9') {
                     return false;
                  }

                  month = (M0 - 48) * 10 + M1 - 48;
               }

               int day;
               if (d0 == 0) {
                  if (d1 < '0' || d1 > '9') {
                     return false;
                  }

                  day = d1 - 48;
               } else {
                  if (d0 < '0' || d0 > '9') {
                     return false;
                  }

                  if (d1 < '0' || d1 > '9') {
                     return false;
                  }

                  day = (d0 - 48) * 10 + d1 - 48;
               }

               if (month < 1) {
                  return false;
               } else if (day < 1) {
                  return false;
               } else {
                  switch (month) {
                     case 1:
                     case 3:
                     case 5:
                     case 7:
                     case 8:
                     case 10:
                     case 12:
                        if (day > 31) {
                           return false;
                        }
                        break;
                     case 2:
                        if (day > 29) {
                           return false;
                        }
                        break;
                     case 4:
                     case 6:
                     case 9:
                     case 11:
                        if (day > 30) {
                           return false;
                        }
                  }

                  int index = len - 1;
                  if (str.charAt(index) == '0' && str.charAt(index - 1) == '.') {
                     index -= 2;
                  }

                  char x0 = str.charAt(index--);
                  char x1 = str.charAt(index--);
                  char x2 = str.charAt(index--);
                  char x3 = str.charAt(index--);
                  char x4 = str.charAt(index--);
                  char x5 = str.charAt(index--);
                  char x6 = str.charAt(index--);
                  char x7 = str.charAt(index--);
                  char x8 = str.charAt(index--);
                  char x9 = str.charAt(index--);
                  char x10 = str.charAt(index--);
                  char x11 = str.charAt(index--);
                  char x12 = str.charAt(index--);
                  char h0;
                  char h1;
                  char m0;
                  char m1;
                  char s0;
                  char s1;
                  if (x5 == ' ') {
                     if (x1 != ':' || x3 != ':') {
                        return false;
                     }

                     s0 = 0;
                     s1 = x0;
                     m0 = 0;
                     m1 = x2;
                     h0 = 0;
                     h1 = x4;
                  } else if (x6 == ' ') {
                     if (x1 == ':') {
                        s0 = 0;
                        s1 = x0;
                        if (x3 == ':') {
                           m0 = 0;
                           m1 = x2;
                           h1 = x4;
                           h0 = x5;
                        } else {
                           if (x4 != ':') {
                              return false;
                           }

                           m0 = x2;
                           m1 = x3;
                           h0 = 0;
                           h1 = x5;
                        }
                     } else {
                        if (x2 != ':') {
                           return false;
                        }

                        s0 = x0;
                        s1 = x1;
                        if (x4 != ':') {
                           return false;
                        }

                        m0 = 0;
                        m1 = x3;
                        h0 = 0;
                        h1 = x5;
                     }
                  } else if (x7 == ' ') {
                     if (x1 == ':') {
                        s0 = 0;
                        s1 = x0;
                        if (x4 != ':') {
                           return false;
                        }

                        m1 = x2;
                        m0 = x3;
                        h1 = x5;
                        h0 = x6;
                     } else {
                        if (x2 != ':') {
                           return false;
                        }

                        s0 = x0;
                        s1 = x1;
                        if (x4 == ':') {
                           m0 = 0;
                           m1 = x3;
                           h1 = x5;
                           h0 = x6;
                        } else {
                           if (x5 != ':') {
                              return false;
                           }

                           m1 = x3;
                           m0 = x4;
                           h0 = 0;
                           h1 = x6;
                        }
                     }
                  } else if (x8 == ' ') {
                     if (x2 != ':' || x5 != ':') {
                        return false;
                     }

                     s1 = x0;
                     s0 = x1;
                     m1 = x3;
                     m0 = x4;
                     h1 = x6;
                     h0 = x7;
                  } else {
                     if (x12 != ' ') {
                        return false;
                     }

                     if (x3 != '.' || x6 != ':' || x9 != ':') {
                        return false;
                     }

                     s1 = x4;
                     s0 = x5;
                     m1 = x7;
                     m0 = x8;
                     h1 = x10;
                     h0 = x11;
                     if (x2 < '0' || x2 > '9') {
                        return false;
                     }

                     if (x1 < '0' || x1 > '9') {
                        return false;
                     }

                     if (x0 < '0' || x0 > '9') {
                        return false;
                     }
                  }

                  if (h0 == 0) {
                     if (h1 < '0' || h1 > '9') {
                        return false;
                     }
                  } else {
                     if (h0 < '0' || h0 > '2') {
                        return false;
                     }

                     if (h1 < '0' || h1 > '9') {
                        return false;
                     }

                     int hour = (h0 - 48) * 10 + (h1 - 48);
                     if (hour > 24) {
                        return false;
                     }
                  }

                  if (m0 == 0) {
                     if (m1 < '0' || m1 > '9') {
                        return false;
                     }
                  } else {
                     if (m0 < '0' || m0 > '6') {
                        return false;
                     }

                     if (m1 < '0' || m1 > '9') {
                        return false;
                     }

                     int minute = (m0 - 48) * 10 + (m1 - 48);
                     if (minute > 60) {
                        return false;
                     }
                  }

                  if (s0 == 0) {
                     if (s1 < '0' || s1 > '9') {
                        return false;
                     }
                  } else {
                     if (s0 < '0' || s0 > '6') {
                        return false;
                     }

                     if (s1 < '0' || s1 > '9') {
                        return false;
                     }

                     int second = (s0 - 48) * 10 + (s1 - 48);
                     if (second > 60) {
                        return false;
                     }
                  }

                  return true;
               }
            }
         }
      } else {
         return false;
      }
   }

   public static SQLTimestampExpr of(String str) {
      return new SQLTimestampExpr(str);
   }
}
