package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class SQLAlterFunctionStatement extends SQLStatementImpl {
   private SQLName name;
   private boolean debug;
   private boolean reuseSettings;
   private SQLExpr comment;
   private boolean languageSql;
   private boolean containsSql;
   private SQLExpr sqlSecurity;
   private boolean noSql;
   private boolean readSqlData;
   private boolean modifiesSqlData;

   public boolean isDebug() {
      return this.debug;
   }

   public void setDebug(boolean debug) {
      this.debug = debug;
   }

   public SQLName getName() {
      return this.name;
   }

   public void setName(SQLName name) {
      if (name != null) {
         name.setParent(this);
      }

      this.name = name;
   }

   public SQLExpr getComment() {
      return this.comment;
   }

   public void setComment(SQLExpr comment) {
      if (comment != null) {
         comment.setParent(this);
      }

      this.comment = comment;
   }

   public boolean isReuseSettings() {
      return this.reuseSettings;
   }

   public void setReuseSettings(boolean x) {
      this.reuseSettings = x;
   }

   public boolean isLanguageSql() {
      return this.languageSql;
   }

   public void setLanguageSql(boolean languageSql) {
      this.languageSql = languageSql;
   }

   public boolean isContainsSql() {
      return this.containsSql;
   }

   public void setContainsSql(boolean containsSql) {
      this.containsSql = containsSql;
   }

   public SQLExpr getSqlSecurity() {
      return this.sqlSecurity;
   }

   public void setSqlSecurity(SQLExpr sqlSecurity) {
      if (sqlSecurity != null) {
         sqlSecurity.setParent(this);
      }

      this.sqlSecurity = sqlSecurity;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.name);
         this.acceptChild(visitor, this.comment);
         this.acceptChild(visitor, this.sqlSecurity);
      }

      visitor.endVisit(this);
   }

   public boolean isNoSql() {
      return this.noSql;
   }

   public void setNoSql(boolean noSql) {
      this.noSql = noSql;
   }

   public boolean isReadSqlData() {
      return this.readSqlData;
   }

   public void setReadSqlData(boolean readSqlData) {
      this.readSqlData = readSqlData;
   }

   public boolean isModifiesSqlData() {
      return this.modifiesSqlData;
   }

   public void setModifiesSqlData(boolean modifiesSqlData) {
      this.modifiesSqlData = modifiesSqlData;
   }
}
