package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class SQLAlterSystemStatement extends SQLStatementImpl {
   protected SQLName item;
   protected SQLExpr value;
   protected boolean deferred = false;
   protected boolean archiveLogCurrent = false;
   protected boolean switchLogfile = false;
   protected Option option;

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
      }

      visitor.endVisit(this);
   }

   public boolean isSwitchLogfile() {
      return this.switchLogfile;
   }

   public void setSwitchLogfile(boolean switchLogfile) {
      this.switchLogfile = switchLogfile;
   }

   public boolean isArchiveLogCurrent() {
      return this.archiveLogCurrent;
   }

   public void setArchiveLogCurrent(boolean archiveLogCurrent) {
      this.archiveLogCurrent = archiveLogCurrent;
   }

   public SQLName getItem() {
      return this.item;
   }

   public void setItem(SQLName item) {
      this.item = item;
   }

   public SQLExpr getValue() {
      return this.value;
   }

   public void setValue(SQLExpr value) {
      this.value = value;
   }

   public boolean isDeferred() {
      return this.deferred;
   }

   public void setDeferred(boolean deferred) {
      this.deferred = deferred;
   }

   public Option getOption() {
      return this.option;
   }

   public void setOption(Option option) {
      this.option = option;
   }

   public static enum Option {
      MEMORY,
      BOTH,
      SPFILE;
   }
}
