package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLObjectImpl;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLAlterTableAddClusteringKey extends SQLObjectImpl implements SQLAlterTableItem {
   private SQLName name;
   private final List<SQLName> columns = new ArrayList();

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         if (this.name != null) {
            this.name.accept(visitor);
         }

         for(SQLName column : this.columns) {
            column.accept(visitor);
         }
      }

      visitor.endVisit(this);
   }

   public SQLName getName() {
      return this.name;
   }

   public void setName(SQLName name) {
      this.name = name;
   }

   public List<SQLName> getColumns() {
      return this.columns;
   }
}
