package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.SQLObjectImpl;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLAlterTableAddPartition extends SQLObjectImpl implements SQLAlterTableItem {
   private boolean ifNotExists = false;
   private final List<SQLObject> partitions = new ArrayList(4);
   private SQLExpr partitionCount;
   private SQLExpr location;

   public List<SQLObject> getPartitions() {
      return this.partitions;
   }

   public void addPartition(SQLObject x) {
      if (x != null) {
         x.setParent(this);
      }

      this.partitions.add(x);
   }

   public boolean isIfNotExists() {
      return this.ifNotExists;
   }

   public void setIfNotExists(boolean ifNotExists) {
      this.ifNotExists = ifNotExists;
   }

   public SQLExpr getPartitionCount() {
      return this.partitionCount;
   }

   public void setPartitionCount(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.partitionCount = x;
   }

   public SQLExpr getLocation() {
      return this.location;
   }

   public void setLocation(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.location = x;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.partitions);
         this.acceptChild(visitor, this.partitionCount);
         this.acceptChild(visitor, this.location);
      }

      visitor.endVisit(this);
   }
}
