package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLObjectImpl;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLAlterTableRebuildPartition extends SQLObjectImpl implements SQLAlterTableItem {
   private final List<SQLName> partitions = new ArrayList(4);

   public List<SQLName> getPartitions() {
      return this.partitions;
   }

   public void addPartition(SQLName partition) {
      if (partition != null) {
         partition.setParent(this);
      }

      this.partitions.add(partition);
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.partitions);
      }

      visitor.endVisit(this);
   }
}
