package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.sql.ast.SQLObjectImpl;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLAlterTableRenamePartition extends SQLObjectImpl implements SQLAlterTableItem {
   private boolean ifNotExists = false;
   private final List<SQLAssignItem> partition = new ArrayList(4);
   private final List<SQLAssignItem> to = new ArrayList(4);

   public List<SQLAssignItem> getPartition() {
      return this.partition;
   }

   public boolean isIfNotExists() {
      return this.ifNotExists;
   }

   public void setIfNotExists(boolean ifNotExists) {
      this.ifNotExists = ifNotExists;
   }

   public List<SQLAssignItem> getTo() {
      return this.to;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.partition);
         this.acceptChild(visitor, this.to);
      }

      visitor.endVisit(this);
   }
}
