package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLObjectImpl;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLAlterTableReplaceColumn extends SQLObjectImpl implements SQLAlterTableItem {
   private final List<SQLColumnDefinition> columns = new ArrayList();
   private SQLName firstColumn;
   private SQLName afterColumn;
   private boolean first;

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.columns);
      }

      visitor.endVisit(this);
   }

   public List<SQLColumnDefinition> getColumns() {
      return this.columns;
   }

   public void addColumn(SQLColumnDefinition column) {
      if (column != null) {
         column.setParent(this);
      }

      this.columns.add(column);
   }

   public SQLName getFirstColumn() {
      return this.firstColumn;
   }

   public void setFirstColumn(SQLName first) {
      this.firstColumn = first;
   }

   public boolean isFirst() {
      return this.first;
   }

   public void setFirst(boolean first) {
      this.first = first;
   }

   public SQLName getAfterColumn() {
      return this.afterColumn;
   }

   public void setAfterColumn(SQLName after) {
      this.afterColumn = after;
   }
}
