package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLExprImpl;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.SQLReplaceable;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.List;

public class SQLAssignItem extends SQLExprImpl implements SQLReplaceable {
   private SQLExpr target;
   private SQLExpr value;

   public SQLAssignItem() {
   }

   public boolean equals(Object o) {
      if (this == o) {
         return true;
      } else if (o != null && this.getClass() == o.getClass()) {
         SQLAssignItem that = (SQLAssignItem)o;
         if (this.target != null) {
            if (!this.target.equals(that.target)) {
               return false;
            }
         } else if (that.target != null) {
            return false;
         }

         return this.value != null ? this.value.equals(that.value) : that.value == null;
      } else {
         return false;
      }
   }

   public int hashCode() {
      int result = this.target != null ? this.target.hashCode() : 0;
      result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
      return result;
   }

   public SQLAssignItem(SQLExpr target, SQLExpr value) {
      this.setTarget(target);
      this.setValue(value);
   }

   public SQLAssignItem clone() {
      SQLAssignItem x = new SQLAssignItem();
      if (this.target != null) {
         x.setTarget(this.target.clone());
      }

      if (this.value != null) {
         x.setValue(this.value.clone());
      }

      return x;
   }

   public List<SQLObject> getChildren() {
      return null;
   }

   public SQLExpr getTarget() {
      return this.target;
   }

   public void setTarget(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.target = x;
   }

   public SQLExpr getValue() {
      return this.value;
   }

   public void setValue(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.value = x;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.target);
         this.acceptChild(visitor, this.value);
      }

      visitor.endVisit(this);
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      if (this.target == expr) {
         this.setTarget(target);
         return true;
      } else if (this.value == expr) {
         this.setValue(target);
         return true;
      } else {
         return false;
      }
   }
}
