package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.ast.expr.SQLVariantRefExpr;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLCallStatement extends SQLStatementImpl {
   private boolean brace = false;
   private SQLVariantRefExpr outParameter;
   private SQLName procedureName;
   private final List<SQLExpr> parameters = new ArrayList();

   public SQLCallStatement() {
   }

   public SQLCallStatement(DbType dbType) {
      super(dbType);
   }

   public SQLVariantRefExpr getOutParameter() {
      return this.outParameter;
   }

   public void setOutParameter(SQLVariantRefExpr outParameter) {
      this.outParameter = outParameter;
   }

   public SQLName getProcedureName() {
      return this.procedureName;
   }

   public void setProcedureName(SQLName procedureName) {
      this.procedureName = procedureName;
   }

   public List<SQLExpr> getParameters() {
      return this.parameters;
   }

   public boolean isBrace() {
      return this.brace;
   }

   public void setBrace(boolean brace) {
      this.brace = brace;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.outParameter);
         this.acceptChild(visitor, this.procedureName);
         this.acceptChild(visitor, this.parameters);
      }

      visitor.endVisit(this);
   }

   public List<SQLObject> getChildren() {
      List<SQLObject> children = new ArrayList();
      children.add(this.outParameter);
      children.add(this.procedureName);
      children.addAll(this.parameters);
      return null;
   }
}
