package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLReplaceable;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class SQLCheck extends SQLConstraintImpl implements SQLTableElement, SQLTableConstraint, SQLReplaceable {
   private SQLExpr expr;
   private Boolean enforced;

   public SQLCheck() {
   }

   public SQLCheck(SQLExpr expr) {
      this.setExpr(expr);
   }

   public SQLExpr getExpr() {
      return this.expr;
   }

   public void setExpr(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.expr = x;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         if (this.getName() != null) {
            this.getName().accept(visitor);
         }

         if (this.expr != null) {
            this.expr.accept(visitor);
         }
      }

      visitor.endVisit(this);
   }

   public void cloneTo(SQLCheck x) {
      super.cloneTo((SQLConstraintImpl)x);
      if (this.expr != null) {
         this.expr = this.expr.clone();
      }

      x.enforced = this.enforced;
   }

   public SQLCheck clone() {
      SQLCheck x = new SQLCheck();
      this.cloneTo(x);
      return x;
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      if (this.expr == expr) {
         this.setExpr(target);
         return true;
      } else if (this.getName() == expr) {
         this.setName((SQLName)target);
         return true;
      } else if (this.getComment() == expr) {
         this.setComment(target);
         return true;
      } else {
         return false;
      }
   }

   public Boolean getEnforced() {
      return this.enforced;
   }

   public void setEnforced(Boolean enforced) {
      this.enforced = enforced;
   }
}
