package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.SQLUtils;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.ast.expr.SQLCharExpr;
import com.chenyang.druid.sql.ast.expr.SQLIdentifierExpr;
import com.chenyang.druid.sql.ast.expr.SQLPropertyExpr;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLCreateTableGroupStatement extends SQLStatementImpl implements SQLCreateStatement {
   protected SQLName name;
   protected boolean ifNotExists = false;
   protected SQLExpr partitionNum;

   public SQLCreateTableGroupStatement() {
   }

   public SQLCreateTableGroupStatement(DbType dbType) {
      super(dbType);
   }

   public String getSchemaName() {
      return this.name instanceof SQLPropertyExpr ? SQLUtils.toMySqlString(((SQLPropertyExpr)this.name).getOwner()) : null;
   }

   public void setSchemaName(String name) {
      if (name != null) {
         this.name = new SQLPropertyExpr(name, this.getTableGroupName());
      }

   }

   public String getTableGroupName() {
      if (this.name instanceof SQLPropertyExpr) {
         return ((SQLPropertyExpr)this.name).getName();
      } else if (this.name instanceof SQLIdentifierExpr) {
         return ((SQLIdentifierExpr)this.name).getName();
      } else {
         return this.name instanceof SQLCharExpr ? ((SQLCharExpr)this.name).getText() : null;
      }
   }

   public SQLExpr getPartitionNum() {
      return this.partitionNum;
   }

   public void setPartitionNum(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.partitionNum = x;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.name);
      }

      visitor.endVisit(this);
   }

   public List<SQLObject> getChildren() {
      List<SQLObject> children = new ArrayList();
      if (this.name != null) {
         children.add(this.name);
      }

      return children;
   }

   public SQLName getName() {
      return this.name;
   }

   public void setName(SQLName name) {
      this.name = name;
   }

   public boolean isIfNotExists() {
      return this.ifNotExists;
   }

   public void setIfNotExists(boolean ifNotExists) {
      this.ifNotExists = ifNotExists;
   }
}
