package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLReplaceable;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class SQLDefault extends SQLConstraintImpl implements SQLTableElement, SQLTableConstraint, SQLReplaceable {
   private SQLExpr expr;
   private SQLExpr column;
   private boolean withValues = false;

   public SQLDefault() {
   }

   public SQLDefault(SQLExpr expr, SQLExpr column) {
      this.setExpr(expr);
      this.setColumn(column);
   }

   public SQLExpr getColumn() {
      return this.column;
   }

   public void setColumn(SQLExpr column) {
      this.column = column;
   }

   public SQLExpr getExpr() {
      return this.expr;
   }

   public void setExpr(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.expr = x;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         if (this.getName() != null) {
            this.getName().accept(visitor);
         }

         if (this.expr != null) {
            this.expr.accept(visitor);
         }
      }

      visitor.endVisit(this);
   }

   public void cloneTo(SQLDefault x) {
      super.cloneTo((SQLConstraintImpl)x);
      if (this.expr != null) {
         x.setExpr(this.expr.clone());
      }

      if (this.column != null) {
         x.setColumn(this.column.clone());
      }

      x.setWithValues(x.isWithValues());
   }

   public SQLDefault clone() {
      SQLDefault x = new SQLDefault();
      this.cloneTo(x);
      return x;
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      if (this.expr == expr) {
         this.setExpr(target);
         return true;
      } else if (this.getName() == expr) {
         this.setName((SQLName)target);
         return true;
      } else if (this.getComment() == expr) {
         this.setComment(target);
         return true;
      } else {
         return false;
      }
   }

   public boolean isWithValues() {
      return this.withValues;
   }

   public void setWithValues(boolean withValues) {
      this.withValues = withValues;
   }
}
