package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.SQLReplaceable;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLDropCatalogStatement extends SQLStatementImpl implements SQLDropStatement, SQLReplaceable {
   private SQLExpr name;
   private boolean ifExists;
   private boolean external;

   public SQLDropCatalogStatement() {
   }

   public SQLDropCatalogStatement(DbType dbType) {
      super(dbType);
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.name);
      }

      visitor.endVisit(this);
   }

   public SQLExpr getName() {
      return this.name;
   }

   public void setName(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.name = x;
   }

   public boolean isIfExists() {
      return this.ifExists;
   }

   public void setIfExists(boolean ifExists) {
      this.ifExists = ifExists;
   }

   public boolean isExternal() {
      return this.external;
   }

   public void setExternal(boolean external) {
      this.external = external;
   }

   public List<SQLObject> getChildren() {
      List<SQLObject> children = new ArrayList();
      if (this.name != null) {
         children.add(this.name);
      }

      return children;
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      if (this.name == expr) {
         this.setName(target);
         return true;
      } else {
         return false;
      }
   }
}
