package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class SQLDropDomainStatement extends SQLStatementImpl implements SQLDropStatement {
   protected boolean cascade = false;
   protected boolean restrict = false;
   protected boolean ifExists = false;
   protected SQLName name;

   public SQLDropDomainStatement(DbType dbType) {
      super(dbType);
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
      }

      visitor.endVisit(this);
   }

   public SQLName getName() {
      return this.name;
   }

   public void setName(SQLName name) {
      this.name = name;
   }

   public boolean isIfExists() {
      return this.ifExists;
   }

   public void setIfExists(boolean ifExists) {
      this.ifExists = ifExists;
   }

   public boolean isCascade() {
      return this.cascade;
   }

   public void setCascade(boolean cascade) {
      this.cascade = cascade;
   }

   public boolean isRestrict() {
      return this.restrict;
   }

   public void setRestrict(boolean restrict) {
      this.restrict = restrict;
   }
}
