package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.SQLReplaceable;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLDropIndexStatement extends SQLStatementImpl implements SQLDropStatement, SQLReplaceable {
   private SQLName indexName;
   private SQLExprTableSource tableName;
   private SQLExpr algorithm;
   private SQLExpr lockOption;
   private boolean ifExists;
   private boolean context;
   private boolean cascade;
   private boolean restrict;

   public boolean isCascade() {
      return this.cascade;
   }

   public void setCascade(boolean cascade) {
      this.cascade = cascade;
   }

   public boolean isRestrict() {
      return this.restrict;
   }

   public void setRestrict(boolean restrict) {
      this.restrict = restrict;
   }

   public SQLDropIndexStatement() {
   }

   public SQLDropIndexStatement(DbType dbType) {
      super(dbType);
   }

   public boolean isContext() {
      return this.context;
   }

   public void setContext(boolean context) {
      this.context = context;
   }

   public SQLName getIndexName() {
      return this.indexName;
   }

   public void setIndexName(SQLName indexName) {
      this.indexName = indexName;
   }

   public SQLExprTableSource getTableName() {
      return this.tableName;
   }

   public void setTableName(SQLName tableName) {
      this.setTableName(new SQLExprTableSource(tableName));
   }

   public void setTableName(SQLExprTableSource tableName) {
      this.tableName = tableName;
   }

   public SQLExpr getAlgorithm() {
      return this.algorithm;
   }

   public void setAlgorithm(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.algorithm = x;
   }

   public SQLExpr getLockOption() {
      return this.lockOption;
   }

   public void setLockOption(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.lockOption = x;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.indexName);
         this.acceptChild(visitor, this.tableName);
         this.acceptChild(visitor, this.algorithm);
         this.acceptChild(visitor, this.lockOption);
      }

      visitor.endVisit(this);
   }

   public List<SQLObject> getChildren() {
      List<SQLObject> children = new ArrayList();
      if (this.indexName != null) {
         children.add(this.indexName);
      }

      if (this.tableName != null) {
         children.add(this.tableName);
      }

      return children;
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      if (this.indexName == expr) {
         this.setIndexName((SQLName)target);
         return true;
      } else if (this.algorithm == expr) {
         this.setAlgorithm(target);
         return true;
      } else if (this.lockOption == expr) {
         this.setLockOption(target);
         return true;
      } else {
         return false;
      }
   }

   public boolean isIfExists() {
      return this.ifExists;
   }

   public void setIfExists(boolean ifExists) {
      this.ifExists = ifExists;
   }
}
