package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLLimit;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLReplaceable;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLFetchStatement extends SQLStatementImpl implements SQLReplaceable {
   private SQLName cursorName;
   private boolean bulkCollect;
   private List<SQLExpr> into = new ArrayList();
   private SQLLimit limit;

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.cursorName);
         this.acceptChild(visitor, this.into);
      }

      visitor.endVisit(this);
   }

   public SQLName getCursorName() {
      return this.cursorName;
   }

   public void setCursorName(SQLName x) {
      if (x != null) {
         x.setParent(this);
      }

      this.cursorName = x;
   }

   public SQLLimit getLimit() {
      return this.limit;
   }

   public void setLimit(SQLLimit x) {
      if (x != null) {
         x.setParent(this);
      }

      this.limit = x;
   }

   public List<SQLExpr> getInto() {
      return this.into;
   }

   public void setInto(List<SQLExpr> into) {
      this.into = into;
   }

   public boolean isBulkCollect() {
      return this.bulkCollect;
   }

   public void setBulkCollect(boolean bulkCollect) {
      this.bulkCollect = bulkCollect;
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      if (this.cursorName == expr) {
         this.setCursorName((SQLName)target);
         return true;
      } else {
         return false;
      }
   }
}
