package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLStatement;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLForStatement extends SQLStatementImpl {
   protected SQLName index;
   protected SQLExpr range;
   protected List<SQLStatement> statements = new ArrayList();

   public SQLName getIndex() {
      return this.index;
   }

   public void setIndex(SQLName index) {
      this.index = index;
   }

   public SQLExpr getRange() {
      return this.range;
   }

   public void setRange(SQLExpr range) {
      if (range != null) {
         range.setParent(this);
      }

      this.range = range;
   }

   public List<SQLStatement> getStatements() {
      return this.statements;
   }

   protected void accept0(SQLASTVisitor v) {
      if (v.visit(this)) {
         this.acceptChild(v, this.index);
         this.acceptChild(v, this.range);
         this.acceptChild(v, this.statements);
      }

      v.endVisit(this);
   }
}
