package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.SQLReplaceable;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.Collections;
import java.util.List;

public class SQLReturnStatement extends SQLStatementImpl implements SQLReplaceable {
   private SQLExpr expr;

   public SQLReturnStatement() {
   }

   public SQLReturnStatement(DbType dbType) {
      super(dbType);
   }

   public SQLExpr getExpr() {
      return this.expr;
   }

   public void setExpr(SQLExpr expr) {
      if (expr != null) {
         expr.setParent(this);
      }

      this.expr = expr;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.expr);
      }

      visitor.endVisit(this);
   }

   public SQLReturnStatement clone() {
      SQLReturnStatement x = new SQLReturnStatement();
      if (this.expr != null) {
         x.setExpr(this.expr.clone());
      }

      return x;
   }

   public List<SQLObject> getChildren() {
      return Collections.singletonList(this.expr);
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      if (this.expr == expr) {
         this.setExpr(target);
         return true;
      } else {
         return false;
      }
   }
}
