package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class SQLRevokeStatement extends SQLPrivilegeStatement {
   private boolean grantOption;
   private boolean cascade = false;
   private boolean restrict = false;

   public SQLRevokeStatement() {
   }

   public SQLRevokeStatement(DbType dbType) {
      super(dbType);
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.resource);
         this.acceptChild(visitor, this.users);
      }

      visitor.endVisit(this);
   }

   public boolean isGrantOption() {
      return this.grantOption;
   }

   public void setGrantOption(boolean grantOption) {
      this.grantOption = grantOption;
   }

   public boolean isCascade() {
      return this.cascade;
   }

   public void setCascade(boolean cascade) {
      this.cascade = cascade;
   }

   public boolean isRestrict() {
      return this.restrict;
   }

   public void setRestrict(boolean restrict) {
      this.restrict = restrict;
   }
}
