package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLShowPartitionsStmt extends SQLStatementImpl implements SQLShowStatement {
   private SQLExprTableSource tableSource;
   private List<SQLAssignItem> partition = new ArrayList();
   private SQLExpr where;

   public SQLShowPartitionsStmt() {
      super(DbType.odps);
   }

   public SQLExprTableSource getTableSource() {
      return this.tableSource;
   }

   public void setTableSource(SQLExpr table) {
      if (table != null) {
         this.setTableSource(new SQLExprTableSource(table));
      }
   }

   public void setTableSource(SQLExprTableSource tableSource) {
      this.tableSource = tableSource;
   }

   public List<SQLAssignItem> getPartition() {
      return this.partition;
   }

   public SQLExpr getWhere() {
      return this.where;
   }

   public void setWhere(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.where = x;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.tableSource);
         this.acceptChild(visitor, this.partition);
         this.acceptChild(visitor, this.where);
      }

      visitor.endVisit(this);
   }
}
