package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SQLShowStatisticStmt extends SQLStatementImpl implements SQLShowStatement {
   private SQLExprTableSource tableSource;
   private boolean full;
   private final List<SQLAssignItem> partitions = new ArrayList(4);

   public SQLShowStatisticStmt() {
      super(DbType.odps);
   }

   public SQLExprTableSource getTableSource() {
      return this.tableSource;
   }

   public void setTableSource(SQLExprTableSource tableSource) {
      this.tableSource = tableSource;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.tableSource);
      }

      visitor.endVisit(this);
   }

   public List<SQLObject> getChildren() {
      return Collections.singletonList(this.tableSource);
   }

   public boolean isFull() {
      return this.full;
   }

   public void setFull(boolean full) {
      this.full = full;
   }

   public List<SQLAssignItem> getPartitions() {
      return this.partitions;
   }

   public void addPartition(SQLAssignItem partition) {
      if (partition != null) {
         partition.setParent(this);
      }

      this.partitions.add(partition);
   }
}
