package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLReplaceable;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class SQLShowTablesStatement extends SQLStatementImpl implements SQLShowStatement, SQLReplaceable {
   private boolean extended = false;
   protected SQLName database;
   protected SQLExpr like;
   protected boolean full;
   protected SQLExpr where;

   public SQLName getDatabase() {
      return this.database;
   }

   public SQLName getFrom() {
      return this.database;
   }

   public void setDatabase(SQLName database) {
      if (database != null) {
         database.setParent(this);
      }

      this.database = database;
   }

   public SQLExpr getLike() {
      return this.like;
   }

   public void setLike(SQLExpr like) {
      if (like != null) {
         like.setParent(this);
      }

      this.like = like;
   }

   public boolean isFull() {
      return this.full;
   }

   public void setFull(boolean full) {
      this.full = full;
   }

   public SQLExpr getWhere() {
      return this.where;
   }

   public void setWhere(SQLExpr where) {
      this.where = where;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.database);
         this.acceptChild(visitor, this.like);
      }

      visitor.endVisit(this);
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      if (this.database == expr) {
         this.setDatabase((SQLName)target);
         return true;
      } else if (this.like == expr) {
         this.setLike(target);
         return true;
      } else if (this.where == expr) {
         this.setWhere(target);
         return true;
      } else {
         return false;
      }
   }

   public boolean isExtended() {
      return this.extended;
   }

   public void setExtended(boolean extended) {
      this.extended = extended;
   }
}
