package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLSubqueryTableSource extends SQLTableSourceImpl {
   protected SQLSelect select;
   protected List<SQLName> columns;

   public SQLSubqueryTableSource() {
      this.columns = new ArrayList();
   }

   public SQLSubqueryTableSource(String alias) {
      super(alias);
      this.columns = new ArrayList();
   }

   public SQLSubqueryTableSource(SQLSelect select, String alias) {
      super(alias);
      this.columns = new ArrayList();
      this.setSelect(select);
   }

   public SQLSubqueryTableSource(SQLSelect select) {
      this.columns = new ArrayList();
      this.setSelect(select);
   }

   public SQLSubqueryTableSource(SQLSelectQuery query) {
      this(new SQLSelect(query));
   }

   public SQLSubqueryTableSource(SQLSelectQuery query, String alias) {
      this(new SQLSelect(query), alias);
   }

   public SQLSelect getSelect() {
      return this.select;
   }

   public void setSelect(SQLSelect x) {
      if (x != null) {
         x.setParent(this);
      }

      this.select = x;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this) && this.select != null) {
         this.select.accept(visitor);
      }

      visitor.endVisit(this);
   }

   public void cloneTo(SQLSubqueryTableSource x) {
      x.alias = this.alias;
      if (this.select != null) {
         x.select = this.select.clone();
         x.select.setParent(x);
      }

      for(SQLName column : this.columns) {
         SQLName c2 = column.clone();
         c2.setParent(x);
         x.columns.add(c2);
      }

   }

   public SQLSubqueryTableSource clone() {
      SQLSubqueryTableSource x = new SQLSubqueryTableSource();
      this.cloneTo(x);
      return x;
   }

   public SQLTableSource findTableSourceWithColumn(String columnName) {
      if (this.select == null) {
         return null;
      } else {
         SQLSelectQueryBlock queryBlock = this.select.getFirstQueryBlock();
         if (queryBlock == null) {
            return null;
         } else {
            return queryBlock.findSelectItem(columnName) != null ? this : null;
         }
      }
   }

   public SQLTableSource findTableSourceWithColumn(long columnNameHash, String columnName, int option) {
      if (this.select == null) {
         return null;
      } else {
         SQLSelectQueryBlock queryBlock = this.select.getFirstQueryBlock();
         if (queryBlock == null) {
            return null;
         } else {
            return queryBlock.findSelectItem(columnNameHash) != null ? this : null;
         }
      }
   }

   public boolean equals(Object o) {
      if (this == o) {
         return true;
      } else if (o != null && this.getClass() == o.getClass()) {
         SQLSubqueryTableSource that = (SQLSubqueryTableSource)o;
         return this.select != null ? this.select.equals(that.select) : that.select == null;
      } else {
         return false;
      }
   }

   public int hashCode() {
      return this.select != null ? this.select.hashCode() : 0;
   }

   public List<SQLName> getColumns() {
      return this.columns;
   }

   public void addColumn(SQLName column) {
      column.setParent(this);
      this.columns.add(column);
   }

   public SQLColumnDefinition findColumn(long columnNameHash) {
      SQLSelectQueryBlock queryBlock = this.select.getFirstQueryBlock();
      if (queryBlock != null) {
         return queryBlock.findColumn(columnNameHash);
      } else if (this.select.getQuery() instanceof SQLUnionQuery && ((SQLUnionQuery)this.select.getQuery()).getFirstQueryBlock() instanceof SQLSelectQueryBlock) {
         SQLSelectQueryBlock left = ((SQLUnionQuery)this.select.getQuery()).getFirstQueryBlock();
         return left.findColumn(columnNameHash);
      } else {
         return null;
      }
   }
}
