package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.ast.expr.SQLIntegerExpr;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLTruncateStatement extends SQLStatementImpl {
   protected List<SQLExprTableSource> tableSources = new ArrayList(2);
   private boolean purgeSnapshotLog = false;
   private boolean only;
   private Boolean restartIdentity;
   private Boolean cascade;
   private boolean dropStorage = false;
   private boolean reuseStorage = false;
   private boolean immediate = false;
   private boolean ignoreDeleteTriggers = false;
   private boolean restrictWhenDeleteTriggers = false;
   private boolean continueIdentity = false;
   protected boolean ifExists = false;
   protected List<SQLAssignItem> partitions = new ArrayList();
   protected boolean partitionAll = false;
   protected List<SQLIntegerExpr> partitionsForADB = new ArrayList();
   protected boolean purge = false;

   public SQLTruncateStatement() {
   }

   public SQLTruncateStatement(DbType dbType) {
      super(dbType);
   }

   public List<SQLExprTableSource> getTableSources() {
      return this.tableSources;
   }

   public void setTableSources(List<SQLExprTableSource> tableSources) {
      this.tableSources = tableSources;
   }

   public void addTableSource(SQLName name) {
      SQLExprTableSource tableSource = new SQLExprTableSource(name);
      tableSource.setParent(this);
      this.tableSources.add(tableSource);
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.tableSources);
      }

      visitor.endVisit(this);
   }

   public boolean isPurgeSnapshotLog() {
      return this.purgeSnapshotLog;
   }

   public void setPurgeSnapshotLog(boolean purgeSnapshotLog) {
      this.purgeSnapshotLog = purgeSnapshotLog;
   }

   public boolean isOnly() {
      return this.only;
   }

   public void setOnly(boolean only) {
      this.only = only;
   }

   public Boolean getRestartIdentity() {
      return this.restartIdentity;
   }

   public void setRestartIdentity(Boolean restartIdentity) {
      this.restartIdentity = restartIdentity;
   }

   public Boolean getCascade() {
      return this.cascade;
   }

   public void setCascade(Boolean cascade) {
      this.cascade = cascade;
   }

   public boolean isDropStorage() {
      return this.dropStorage;
   }

   public void setDropStorage(boolean dropStorage) {
      this.dropStorage = dropStorage;
   }

   public boolean isReuseStorage() {
      return this.reuseStorage;
   }

   public void setReuseStorage(boolean reuseStorage) {
      this.reuseStorage = reuseStorage;
   }

   public boolean isImmediate() {
      return this.immediate;
   }

   public void setImmediate(boolean immediate) {
      this.immediate = immediate;
   }

   public boolean isIgnoreDeleteTriggers() {
      return this.ignoreDeleteTriggers;
   }

   public void setIgnoreDeleteTriggers(boolean ignoreDeleteTriggers) {
      this.ignoreDeleteTriggers = ignoreDeleteTriggers;
   }

   public boolean isRestrictWhenDeleteTriggers() {
      return this.restrictWhenDeleteTriggers;
   }

   public void setRestrictWhenDeleteTriggers(boolean restrictWhenDeleteTriggers) {
      this.restrictWhenDeleteTriggers = restrictWhenDeleteTriggers;
   }

   public boolean isContinueIdentity() {
      return this.continueIdentity;
   }

   public void setContinueIdentity(boolean continueIdentity) {
      this.continueIdentity = continueIdentity;
   }

   public List getChildren() {
      return this.tableSources;
   }

   public boolean isIfExists() {
      return this.ifExists;
   }

   public void setIfExists(boolean ifExists) {
      this.ifExists = ifExists;
   }

   public List<SQLAssignItem> getPartitions() {
      return this.partitions;
   }

   public boolean isPartitionAll() {
      return this.partitionAll;
   }

   public void setPartitionAll(boolean partitionAll) {
      this.partitionAll = partitionAll;
   }

   public List<SQLIntegerExpr> getPartitionsForADB() {
      return this.partitionsForADB;
   }

   public boolean isPurge() {
      return this.purge;
   }

   public void setPurge(boolean purge) {
      this.purge = purge;
   }
}
