package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.SQLReplaceable;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.Collections;
import java.util.List;

public class SQLUseStatement extends SQLStatementImpl implements SQLReplaceable {
   private SQLName database;

   public SQLUseStatement() {
   }

   public SQLUseStatement(DbType dbType) {
      super(dbType);
   }

   public SQLName getDatabase() {
      return this.database;
   }

   public void setDatabase(SQLName x) {
      if (x != null) {
         x.setParent(this);
      }

      this.database = x;
   }

   public void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.database);
      }

      visitor.endVisit(this);
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      if (this.database == expr) {
         this.setDatabase((SQLName)target);
         return true;
      } else {
         return false;
      }
   }

   public List<SQLObject> getChildren() {
      return Collections.singletonList(this.database);
   }
}
