package com.chenyang.druid.sql.dialect.ads.parser;

import com.chenyang.druid.sql.ast.SQLStatement;
import com.chenyang.druid.sql.ast.statement.SQLCreateTableStatement;
import com.chenyang.druid.sql.ast.statement.SQLShowColumnsStatement;
import com.chenyang.druid.sql.ast.statement.SQLShowCreateTableStatement;
import com.chenyang.druid.sql.ast.statement.SQLShowDatabasesStatement;
import com.chenyang.druid.sql.ast.statement.SQLShowProcessListStatement;
import com.chenyang.druid.sql.ast.statement.SQLShowTableGroupsStatement;
import com.chenyang.druid.sql.ast.statement.SQLShowTablesStatement;
import com.chenyang.druid.sql.parser.Lexer;
import com.chenyang.druid.sql.parser.ParserException;
import com.chenyang.druid.sql.parser.SQLCreateTableParser;
import com.chenyang.druid.sql.parser.SQLExprParser;
import com.chenyang.druid.sql.parser.SQLParserFeature;
import com.chenyang.druid.sql.parser.SQLStatementParser;
import com.chenyang.druid.sql.parser.Token;
import com.chenyang.druid.util.FnvHash;

public class AdsStatementParser extends SQLStatementParser {
   public AdsStatementParser(String sql) {
      super((SQLExprParser)(new AdsExprParser(sql)));
   }

   public AdsStatementParser(String sql, SQLParserFeature... features) {
      super((SQLExprParser)(new AdsExprParser(sql, features)));
   }

   public AdsStatementParser(Lexer lexer) {
      super((SQLExprParser)(new AdsExprParser(lexer)));
   }

   public AdsSelectParser createSQLSelectParser() {
      return new AdsSelectParser(this.exprParser, this.selectListCache);
   }

   public SQLCreateTableParser getSQLCreateTableParser() {
      return new AdsCreateTableParser(this.exprParser);
   }

   public SQLCreateTableStatement parseCreateTable() {
      AdsCreateTableParser parser = new AdsCreateTableParser(this.exprParser);
      return parser.parseCreateTable(true);
   }

   public SQLStatement parseShow() {
      this.accept(Token.SHOW);
      if (this.lexer.identifierEquals(FnvHash.Constants.DATABASES)) {
         this.lexer.nextToken();
         SQLShowDatabasesStatement stmt = this.parseShowDatabases(false);
         return stmt;
      } else if (this.lexer.identifierEquals(FnvHash.Constants.TABLES)) {
         this.lexer.nextToken();
         SQLShowTablesStatement stmt = this.parseShowTables();
         return stmt;
      } else if (this.lexer.identifierEquals(FnvHash.Constants.COLUMNS)) {
         this.lexer.nextToken();
         SQLShowColumnsStatement stmt = this.parseShowColumns();
         return stmt;
      } else if (this.lexer.identifierEquals(FnvHash.Constants.TABLEGROUPS)) {
         this.lexer.nextToken();
         SQLShowTableGroupsStatement stmt = this.parseShowTableGroups();
         return stmt;
      } else if (this.lexer.identifierEquals(FnvHash.Constants.PROCESSLIST)) {
         this.lexer.nextToken();
         SQLShowProcessListStatement stmt = new SQLShowProcessListStatement();
         if (this.lexer.identifierEquals(FnvHash.Constants.MPP)) {
            this.lexer.nextToken();
            stmt.setMpp(true);
         }

         return stmt;
      } else if (this.lexer.token() == Token.CREATE) {
         this.lexer.nextToken();
         this.accept(Token.TABLE);
         SQLShowCreateTableStatement stmt = new SQLShowCreateTableStatement();
         stmt.setName(this.exprParser.name());
         return stmt;
      } else {
         if (this.lexer.token() == Token.ALL) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.CREATE) {
               this.lexer.nextToken();
               this.accept(Token.TABLE);
               SQLShowCreateTableStatement stmt = new SQLShowCreateTableStatement();
               stmt.setAll(true);
               stmt.setName(this.exprParser.name());
               return stmt;
            }
         }

         throw new ParserException("TODO " + this.lexer.info());
      }
   }
}
