package com.chenyang.druid.sql.dialect.blink.parser;

import com.chenyang.druid.sql.parser.Lexer;
import com.chenyang.druid.sql.parser.SQLCreateTableParser;
import com.chenyang.druid.sql.parser.SQLExprParser;
import com.chenyang.druid.sql.parser.SQLParserFeature;
import com.chenyang.druid.sql.parser.SQLStatementParser;

public class BlinkStatementParser extends SQLStatementParser {
   public BlinkStatementParser(String sql) {
      super((SQLExprParser)(new BlinkExprParser(sql)));
   }

   public BlinkStatementParser(String sql, SQLParserFeature... features) {
      super((SQLExprParser)(new BlinkExprParser(sql, features)));
   }

   public BlinkStatementParser(Lexer lexer) {
      super((SQLExprParser)(new BlinkExprParser(lexer)));
   }

   public SQLCreateTableParser getSQLCreateTableParser() {
      return new BlinkCreateTableParser(this.exprParser);
   }
}
