package com.chenyang.druid.sql.dialect.blink.vsitor;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.statement.SQLCreateTableStatement;
import com.chenyang.druid.sql.ast.statement.SQLTableElement;
import com.chenyang.druid.sql.dialect.blink.ast.BlinkCreateTableStatement;
import com.chenyang.druid.sql.visitor.SQLASTOutputVisitor;
import java.util.List;

public class BlinkOutputVisitor extends SQLASTOutputVisitor implements BlinkVisitor {
   public BlinkOutputVisitor(Appendable appender) {
      super(appender);
   }

   public BlinkOutputVisitor(Appendable appender, DbType dbType) {
      super(appender, dbType);
   }

   public BlinkOutputVisitor(Appendable appender, boolean parameterized) {
      super(appender, parameterized);
   }

   public boolean visit(BlinkCreateTableStatement x) {
      super.visit((SQLCreateTableStatement)x);
      return false;
   }

   protected void printTableElements(List<SQLTableElement> tableElementList) {
      int size = tableElementList.size();
      if (size != 0) {
         BlinkCreateTableStatement stmt = (BlinkCreateTableStatement)((SQLTableElement)tableElementList.get(0)).getParent();
         this.print0(" (");
         ++this.indentCount;
         this.println();

         for(int i = 0; i < size; ++i) {
            SQLTableElement element = (SQLTableElement)tableElementList.get(i);
            element.accept(this);
            if (i != size - 1) {
               this.print(',');
            }

            if (this.isPrettyFormat() && element.hasAfterComment()) {
               this.print(' ');
               this.printlnComment(element.getAfterCommentsDirect());
            }

            if (i != size - 1) {
               this.println();
            }
         }

         if (stmt.getPeriodFor() != null) {
            this.print(',');
            this.println();
            this.print0(this.ucase ? "PERIOD FOR " : "period for ");
            stmt.getPeriodFor().accept(this);
         }

         --this.indentCount;
         this.println();
         this.print(')');
      }
   }

   public void endVisit(BlinkCreateTableStatement x) {
   }
}
