package com.chenyang.druid.sql.dialect.db2.ast.expr;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.dialect.db2.ast.DB2SQLObjectImpl;
import com.chenyang.druid.sql.dialect.db2.visitor.DB2ASTVisitor;
import util.sqlparse.visitor.common.Objects;

public class DB2ColumnSimpleDefinitionExpr extends DB2SQLObjectImpl {
   private SQLName name;
   private SQLExpr type;

   public SQLName getName() {
      return this.name;
   }

   public void setName(SQLName name) {
      this.name = name;
      name.setParent(this);
   }

   public SQLExpr getType() {
      return this.type;
   }

   public void setType(SQLExpr type) {
      this.type = type;
      if (type != null) {
         type.setParent(this);
      }

   }

   public void accept0(DB2ASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.name);
         this.acceptChild(visitor, this.type);
      }

      visitor.endVisit(this);
   }

   public DB2ColumnSimpleDefinitionExpr clone() {
      DB2ColumnSimpleDefinitionExpr e = new DB2ColumnSimpleDefinitionExpr();
      e.name = this.name.clone();
      if (this.type != null) {
         e.type = this.type.clone();
      }

      return e;
   }

   public boolean equals(Object o) {
      if (this == o) {
         return true;
      } else if (o != null && this.getClass() == o.getClass()) {
         DB2ColumnSimpleDefinitionExpr that = (DB2ColumnSimpleDefinitionExpr)o;
         if (this.name == null && that.name != null) {
            return false;
         } else if (this.type == null && that.type != null) {
            return false;
         } else {
            return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type);
         }
      } else {
         return false;
      }
   }

   public int hashCode() {
      int prime = 31;
      int result = 31 * this.name.hashCode();
      if (this.type != null) {
         result = prime * result + this.type.hashCode();
      }

      return result;
   }
}
