package com.chenyang.druid.sql.dialect.db2.ast.expr;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.SQLReplaceable;
import com.chenyang.druid.sql.dialect.db2.visitor.DB2ASTVisitor;
import java.util.Collections;
import java.util.List;

public class DB2InetExpr extends DB2ExprImpl implements SQLReplaceable {
   private SQLExpr value;

   public DB2InetExpr clone() {
      DB2InetExpr x = new DB2InetExpr();
      if (this.value != null) {
         x.setValue(this.value.clone());
      }

      return x;
   }

   public SQLExpr getValue() {
      return this.value;
   }

   public void setValue(SQLExpr value) {
      this.value = value;
   }

   public void accept0(DB2ASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.value);
      }

      visitor.endVisit(this);
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      if (this.value == expr) {
         this.setValue(target);
         return true;
      } else {
         return false;
      }
   }

   public List<SQLObject> getChildren() {
      return Collections.singletonList(this.value);
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         DB2InetExpr other = (DB2InetExpr)obj;
         if (this.value == null) {
            if (other.value != null) {
               return false;
            }
         } else if (!this.value.equals(other.value)) {
            return false;
         }

         return true;
      }
   }
}
