package com.chenyang.druid.sql.dialect.db2.ast.stmt;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.ast.expr.SQLIdentifierExpr;
import com.chenyang.druid.sql.ast.statement.SQLAlterStatement;
import com.chenyang.druid.sql.dialect.db2.visitor.DB2ASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class DB2AlterSchemaStatement extends SQLStatementImpl implements DB2SQLStatement, SQLAlterStatement {
   private SQLExpr schemaName;
   private SQLIdentifierExpr newName;
   private SQLIdentifierExpr newOwner;
   private boolean path;
   private SQLExpr schemaPath;
   private boolean dataVersionRetentionTime;
   private SQLExpr dataVersionRetentionTimeNum;

   public DB2AlterSchemaStatement() {
      this.dbType = DbType.db2;
   }

   public SQLExpr getSchemaName() {
      return this.schemaName;
   }

   public void setSchemaName(SQLExpr schemaName) {
      this.schemaName = schemaName;
   }

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((DB2ASTVisitor)visitor);
   }

   public SQLIdentifierExpr getNewName() {
      return this.newName;
   }

   public void setNewName(SQLIdentifierExpr newName) {
      this.newName = newName;
   }

   public SQLIdentifierExpr getNewOwner() {
      return this.newOwner;
   }

   public void setNewOwner(SQLIdentifierExpr newOwner) {
      this.newOwner = newOwner;
   }

   public boolean isPath() {
      return this.path;
   }

   public void setPath(boolean path) {
      this.path = path;
   }

   public SQLExpr getSchemaPath() {
      return this.schemaPath;
   }

   public void setSchemaPath(SQLExpr schemaPath) {
      this.schemaPath = schemaPath;
   }

   public boolean isDataVersionRetentionTime() {
      return this.dataVersionRetentionTime;
   }

   public void setDataVersionRetentionTime(boolean dataVersionRetentionTime) {
      this.dataVersionRetentionTime = dataVersionRetentionTime;
   }

   public SQLExpr getDataVersionRetentionTimeNum() {
      return this.dataVersionRetentionTimeNum;
   }

   public void setDataVersionRetentionTimeNum(SQLExpr dataVersionRetentionTimeNum) {
      this.dataVersionRetentionTimeNum = dataVersionRetentionTimeNum;
   }

   public void accept0(DB2ASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.schemaName);
         this.acceptChild(visitor, this.newName);
         this.acceptChild(visitor, this.newOwner);
      }

      visitor.endVisit(this);
   }
}
