package com.chenyang.druid.sql.dialect.db2.ast.stmt;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.dialect.db2.visitor.DB2ASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class DB2ConnectToStatement extends SQLStatementImpl implements DB2SQLStatement {
   private SQLName target;

   public DB2ConnectToStatement() {
      super(DbType.db2);
   }

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((DB2ASTVisitor)visitor);
   }

   public void accept0(DB2ASTVisitor v) {
      if (v.visit(this)) {
         this.acceptChild(v, this.target);
      }

      v.endVisit(this);
   }

   public SQLName getTarget() {
      return this.target;
   }

   public void setTarget(SQLName x) {
      if (x != null) {
         x.setParent(this);
      }

      this.target = x;
   }
}
