package com.chenyang.druid.sql.dialect.db2.ast.stmt;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.expr.SQLIdentifierExpr;
import com.chenyang.druid.sql.ast.statement.SQLDropSequenceStatement;
import com.chenyang.druid.sql.dialect.db2.visitor.DB2ASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;

public class DB2DropSequenceStatement extends SQLDropSequenceStatement {
   private ArrayList<SQLIdentifierExpr> seqList = new ArrayList();
   private boolean cascade;
   private boolean restrict;
   private boolean large;

   public boolean isLarge() {
      return this.large;
   }

   public void setLarge(boolean large) {
      this.large = large;
   }

   public DB2DropSequenceStatement() {
      this.dbType = DbType.db2;
   }

   public ArrayList<SQLIdentifierExpr> getSeqList() {
      return this.seqList;
   }

   public void setSeqList(ArrayList<SQLIdentifierExpr> seqList) {
      this.seqList = seqList;
   }

   public boolean isCascade() {
      return this.cascade;
   }

   public void setCascade(boolean cascade) {
      this.cascade = cascade;
   }

   public boolean isRestrict() {
      return this.restrict;
   }

   public void setRestrict(boolean restrict) {
      this.restrict = restrict;
   }

   public void accept0(SQLASTVisitor visitor) {
      this.accept0((DB2ASTVisitor)visitor);
   }

   public void accept0(DB2ASTVisitor visitor) {
      visitor.visit(this);
   }
}
