package com.chenyang.druid.sql.dialect.db2.ast.stmt.alterTable;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.statement.SQLAlterTableItem;
import com.chenyang.druid.sql.dialect.db2.ast.DB2SQLObject;
import com.chenyang.druid.sql.dialect.db2.ast.DB2SQLObjectImpl;
import com.chenyang.druid.sql.dialect.db2.visitor.DB2ASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class DB2AlterTableInheriteOrNotParentTable extends DB2SQLObjectImpl implements SQLAlterTableItem, DB2SQLObject {
   private boolean inherite = false;
   private SQLExpr parentTable;

   public boolean isInherite() {
      return this.inherite;
   }

   public void setInherite(boolean inherite) {
      this.inherite = inherite;
   }

   public SQLExpr getParentTable() {
      return this.parentTable;
   }

   public void setParentTable(SQLExpr parentTable) {
      this.parentTable = parentTable;
      parentTable.setParent(this);
   }

   public void accept0(SQLASTVisitor visitor) {
      this.accept0((DB2ASTVisitor)visitor);
   }

   public void accept0(DB2ASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.parentTable);
      }

      visitor.endVisit(this);
   }

   public DB2AlterTableInheriteOrNotParentTable clone() {
      DB2AlterTableInheriteOrNotParentTable c = new DB2AlterTableInheriteOrNotParentTable();
      c.setParentTable(this.parentTable.clone());
      c.inherite = this.inherite;
      return c;
   }
}
