package com.chenyang.druid.sql.dialect.db2.ast.stmt.alterTable;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.statement.SQLAlterTableItem;
import com.chenyang.druid.sql.dialect.db2.ast.DB2SQLObjectImpl;
import com.chenyang.druid.sql.dialect.db2.visitor.DB2ASTVisitor;

public class DB2AlterTableSetSchema extends DB2SQLObjectImpl implements SQLAlterTableItem {
   private SQLExpr schema;

   public void accept0(DB2ASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.schema);
      }

      visitor.endVisit(this);
   }

   public SQLExpr getSchema() {
      return this.schema;
   }

   public void setSchema(SQLExpr schema) {
      schema.setParent(this);
      this.schema = schema;
   }

   public DB2AlterTableSetSchema clone() {
      DB2AlterTableSetSchema c = new DB2AlterTableSetSchema();
      c.setSchema(this.schema.clone());
      return c;
   }
}
