package com.chenyang.druid.sql.dialect.dm.ast.stmt;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.statement.SQLCreateTriggerStatement;
import com.chenyang.druid.sql.dialect.dm.ast.DmSQLObjectImpl;
import com.chenyang.druid.sql.dialect.dm.visitor.DmASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTOutputVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;

public class DmCreateTriggerStatement extends SQLCreateTriggerStatement implements DmStatement {
   protected boolean local;
   protected boolean database;
   protected boolean schema;
   protected boolean forEachStatement = false;
   protected boolean withEncryption = false;
   protected SQLName newRow;
   protected SQLName oldRow;
   protected SQLName schemaName;
   protected ArrayList<SQLExpr> events = new ArrayList();
   protected Timer timer;

   public boolean isLocal() {
      return this.local;
   }

   public void setLocal(boolean local) {
      this.local = local;
   }

   public boolean isWithEncryption() {
      return this.withEncryption;
   }

   public void setWithEncryption(boolean withEncryption) {
      this.withEncryption = withEncryption;
   }

   public DmCreateTriggerStatement() {
      super(DbType.dm);
   }

   public void accept0(DmASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.getName());
         this.acceptChild(visitor, this.getUpdateOfColumns());
         this.acceptChild(visitor, this.getOn());
         this.acceptChild(visitor, this.getWhen());
         this.acceptChild(visitor, this.getBody());
      }

      visitor.endVisit(this);
   }

   protected void accept0(SQLASTVisitor v) {
      if (v instanceof DmASTVisitor) {
         this.accept0((DmASTVisitor)v);
      } else {
         if (v instanceof SQLASTOutputVisitor) {
            ((SQLASTOutputVisitor)v).print(this.toString());
         }

      }
   }

   public Timer getTimer() {
      return this.timer;
   }

   public void setTimer(Timer timer) {
      this.timer = timer;
   }

   public boolean isForEachStatement() {
      return this.forEachStatement;
   }

   public void setForEachStatement(boolean forEachStatement) {
      this.forEachStatement = forEachStatement;
   }

   public SQLName getNewRow() {
      return this.newRow;
   }

   public void setNewRow(SQLName newRow) {
      this.newRow = newRow;
   }

   public SQLName getOldRow() {
      return this.oldRow;
   }

   public void setOldRow(SQLName oldRow) {
      this.oldRow = oldRow;
   }

   public ArrayList<SQLExpr> getEvents() {
      return this.events;
   }

   public void setEvents(ArrayList<SQLExpr> events) {
      this.events = events;
   }

   public boolean isSchema() {
      return this.schema;
   }

   public void setSchema(boolean schema) {
      this.schema = schema;
   }

   public boolean isDatabase() {
      return this.database;
   }

   public void setDatabase(boolean database) {
      this.database = database;
   }

   public SQLName getSchemaName() {
      return this.schemaName;
   }

   public void setSchemaName(SQLName schemaName) {
      this.schemaName = schemaName;
   }

   public static class Timer extends DmSQLObjectImpl {
      protected Type type;
      protected SQLExpr datetime;
      protected SQLExpr month_rate;
      protected SQLExpr day_in_month;
      protected DayInMonthWeek day_in_month_week;
      protected SQLExpr week_rate;
      protected ArrayList<SQLExpr> day_of_week_list = new ArrayList();
      protected SQLExpr day_rate;
      protected SQLExpr once_in_day;
      protected SQLExpr times_in_day;
      protected SQLExpr exec_ep_seqno;
      protected DuaringTime duaringTime;
      protected DuaringDate duaringDate;

      public SQLExpr getExec_ep_seqno() {
         return this.exec_ep_seqno;
      }

      public void setExec_ep_seqno(SQLExpr exec_ep_seqno) {
         this.exec_ep_seqno = exec_ep_seqno;
      }

      public DuaringDate getDuaringDate() {
         return this.duaringDate;
      }

      public void setDuaringDate(DuaringDate duaringDate) {
         this.duaringDate = duaringDate;
      }

      public DuaringTime getDuaringTime() {
         return this.duaringTime;
      }

      public void setDuaringTime(DuaringTime duaringTime) {
         this.duaringTime = duaringTime;
      }

      public SQLExpr getTimes_in_day() {
         return this.times_in_day;
      }

      public void setTimes_in_day(SQLExpr times_in_day) {
         this.times_in_day = times_in_day;
      }

      public SQLExpr getDay_rate() {
         return this.day_rate;
      }

      public void setDay_rate(SQLExpr day_rate) {
         this.day_rate = day_rate;
      }

      public Type getType() {
         return this.type;
      }

      public void setType(Type type) {
         this.type = type;
      }

      public SQLExpr getDatetime() {
         return this.datetime;
      }

      public SQLExpr getMonth_rate() {
         return this.month_rate;
      }

      public void setMonth_rate(SQLExpr month_rate) {
         this.month_rate = month_rate;
      }

      public SQLExpr getDay_in_month() {
         return this.day_in_month;
      }

      public void setDay_in_month(SQLExpr day_in_month) {
         this.day_in_month = day_in_month;
      }

      public DayInMonthWeek getDay_in_month_week() {
         return this.day_in_month_week;
      }

      public SQLExpr getOnce_in_day() {
         return this.once_in_day;
      }

      public void setOnce_in_day(SQLExpr once_in_day) {
         this.once_in_day = once_in_day;
      }

      public void setDay_in_month_week(DayInMonthWeek day_in_month_week) {
         this.day_in_month_week = day_in_month_week;
      }

      public void setDatetime(SQLExpr datetime) {
         this.datetime = datetime;
      }

      public SQLExpr getWeek_rate() {
         return this.week_rate;
      }

      public void setWeek_rate(SQLExpr week_rate) {
         this.week_rate = week_rate;
      }

      public ArrayList<SQLExpr> getDay_of_week_list() {
         return this.day_of_week_list;
      }

      public void setDay_of_week_list(ArrayList<SQLExpr> day_of_week_list) {
         this.day_of_week_list = day_of_week_list;
      }

      public void accept0(DmASTVisitor visitor) {
         if (visitor.visit(this)) {
         }

         visitor.endVisit(this);
      }

      public static enum Type {
         ONCE,
         RATE;
      }

      public static class DayInMonthWeek extends DmSQLObjectImpl {
         protected SQLExpr day;
         protected SQLExpr week;

         public void accept0(DmASTVisitor visitor) {
            if (visitor.visit(this)) {
            }

            visitor.endVisit(this);
         }

         public SQLExpr getWeek() {
            return this.week;
         }

         public void setWeek(SQLExpr week) {
            this.week = week;
         }

         public SQLExpr getDay() {
            return this.day;
         }

         public void setDay(SQLExpr day) {
            this.day = day;
         }
      }

      public static class DuaringTime extends DmSQLObjectImpl {
         protected SQLExpr from;
         protected SQLExpr to;

         public void accept0(DmASTVisitor visitor) {
            if (visitor.visit(this)) {
            }

            visitor.endVisit(this);
         }

         public SQLExpr getFrom() {
            return this.from;
         }

         public void setFrom(SQLExpr from) {
            this.from = from;
         }

         public SQLExpr getTo() {
            return this.to;
         }

         public void setTo(SQLExpr to) {
            this.to = to;
         }
      }

      public static class DuaringDate extends DmSQLObjectImpl {
         protected SQLExpr from;
         protected SQLExpr to;

         public void accept0(DmASTVisitor visitor) {
            if (visitor.visit(this)) {
            }

            visitor.endVisit(this);
         }

         public SQLExpr getFrom() {
            return this.from;
         }

         public void setFrom(SQLExpr from) {
            this.from = from;
         }

         public SQLExpr getTo() {
            return this.to;
         }

         public void setTo(SQLExpr to) {
            this.to = to;
         }
      }
   }
}
