package com.chenyang.druid.sql.dialect.dm.ast.stmt;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.statement.SQLTruncateStatement;
import com.chenyang.druid.sql.dialect.dm.visitor.DmASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTOutputVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class DmSQLTruncateStatement extends SQLTruncateStatement implements DmStatement {
   protected SQLName partitionName;

   public DmSQLTruncateStatement(DbType dbType) {
      super(dbType);
   }

   protected void accept0(SQLASTVisitor v) {
      if (v instanceof DmASTVisitor) {
         this.accept0((DmASTVisitor)v);
      } else {
         if (v instanceof SQLASTOutputVisitor) {
            ((SQLASTOutputVisitor)v).print(this.toString());
         }

      }
   }

   public void accept0(DmASTVisitor visitor) {
      if (visitor.visit(this)) {
      }

      visitor.endVisit(this);
   }

   public SQLName getPartitionName() {
      return this.partitionName;
   }

   public void setPartitionName(SQLName partitionName) {
      this.partitionName = partitionName;
   }
}
