package com.chenyang.druid.sql.dialect.dm.ast.stmt;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.SQLUtils;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.dialect.dm.visitor.DmASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTOutputVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public abstract class DmStatementImpl extends SQLStatementImpl implements DmStatement {
   public DmStatementImpl() {
      super(DbType.dm);
   }

   protected void accept0(SQLASTVisitor v) {
      if (v instanceof DmASTVisitor) {
         this.accept0((DmASTVisitor)v);
      } else {
         if (v instanceof SQLASTOutputVisitor) {
            ((SQLASTOutputVisitor)v).print(this.toString());
         }

      }
   }

   public abstract void accept0(DmASTVisitor var1);

   public String toString() {
      return SQLUtils.toDmString(this);
   }
}
