lexer grammar EsLexer;
/** Taken from "The Definitive ANTLR 4 Reference" by Terence Parr */
// Derived from http://json.org

//HTTP METHOD
GET: [gG][eE][tT];
PUT: [pP][uU][tT];
POST: [pP][oO][sS][tT];
DELETE: [dD][eE][lL][eE][tT][eE];
HEAD : [hH][eE][aA][dD];
OPTIONS : [oO][pP][tT][iI][oO][nN][sS];

SLASH: '/';
LPAREN: '{';
RPAREN:'}';
LSQUARE:'[';
RSQUARE:']';
COLON:':';
NULL:'null';
BOOLEAN_TRUE:'true';
BOOLEAN_FALSE:'false';

//API method name
ENRICH : '_enrich';
POLICY : 'policy';
CREATE : '_create';
UPDATE : '_update';
SEARCH_SHARDS : '_search_shards';
SEARCH : '_search';
MAPPING1 :  '_mapping' ;
DELETE_BY_QUERY : '_delete_by_query';
UPDATE_BY_QUERY : '_update_by_query';
MGET : '_mget';
BULK : '_bulk';
REINDEX : '_reindex';
TERMVECTORS : '_termvectors';
MTERMVECTORS : '_mtermvectors';
EXECUTE : '_execute';
STATS1 : '_stats';
AUTO_SCALING : '_autoscaling';
CAT : '_cat';
CLUSTER : '_cluster';
NODES : '_nodes';
REMOTE : '_remote';
TASKS :  '_tasks';
CCR : '_ccr';
DATA_STREAM : '_data_stream';
FEATURES : '_features';
FLEET : '_fleet';
FIND_STRUCTURE : '_text_structure';
GRAPH : '_graph';
CLOSE : '_close';
OPEN : '_open';
SHRINK : '_shrink';
CLONE : '_clone';
ROLLOVER : '_rollover';
UNFREEZE : '_unfreeze';
FREEZE : '_freeze';
RESLOVE : '_resolve';
MSEARCH : '_msearch';
RENDER : '_render';
COUNT : '_count';
TERMS_ENUM : '_terms_enum';
ASYNC_SEARCH : '_async_search';
EXPLAIN : '_explain';
FIELD_CAPS : '_field_caps';
RANK_EVAL : '_rank_eval';
DOC1 :  '_doc' ;


// ELASTIC KEYWORDS
CONNECTIONS : DBQUOTE 'connections' DBQUOTE;
VERTICES : DBQUOTE 'vertices' DBQUOTE;
MATCH_FIELD : DBQUOTE 'match_field' DBQUOTE;
ENRICH_FIELDS : DBQUOTE 'enrich_fields' DBQUOTE;
CREATE1 : DBQUOTE 'create' DBQUOTE;
DELETE1 : DBQUOTE 'delete' DBQUOTE;
UPDATE1 : DBQUOTE 'update' DBQUOTE;
INDEX1 : DBQUOTE '_index' DBQUOTE;
DOCS : DBQUOTE 'docs' DBQUOTE;
OPERATOR: DBQUOTE 'operator' DBQUOTE;
IDS: DBQUOTE 'ids' DBQUOTE;
EXISTS : DBQUOTE 'exists' DBQUOTE;
REVERSE_NESTED : DBQUOTE 'reverse_nested' DBQUOTE;
NESTED : DBQUOTE 'nested' DBQUOTE;
PATH : DBQUOTE 'path' DBQUOTE;
SCORE1 : DBQUOTE '_score' DBQUOTE;
STORED_FIELDS1 : DBQUOTE '_stored_fields' DBQUOTE;
STORED_FIELDS : DBQUOTE 'stored_fields' DBQUOTE;
DOCVALUE_FIELDS : DBQUOTE 'docvalue_fields' DBQUOTE;
DOC : DBQUOTE 'doc' DBQUOTE;
VALUES : DBQUOTE  'values' DBQUOTE;
VALUE_COUNT: DBQUOTE 'value_count' DBQUOTE;
VALUE : DBQUOTE 'value' DBQUOTE;
COLLAPSE : DBQUOTE 'collapse' DBQUOTE;
SCRIPT_SCORE : DBQUOTE 'script_score' DBQUOTE;
SCRIPT : DBQUOTE 'script' DBQUOTE;
RUNTIME : DBQUOTE 'runtime' DBQUOTE;
SIMPLE_QUERY_STRING : DBQUOTE 'simple_query_string' DBQUOTE;
QUERY_STRING : DBQUOTE 'query_string' DBQUOTE;
QUERY : DBQUOTE'query' DBQUOTE;
FUZZY : DBQUOTE 'fuzzy' DBQUOTE;
FIELDS : DBQUOTE 'fields' DBQUOTE;
FIELD : DBQUOTE 'field' DBQUOTE;
SHOULD : DBQUOTE 'should' DBQUOTE;
MUST_NOT : DBQUOTE 'must_not' DBQUOTE;
MUST : DBQUOTE 'must' DBQUOTE;
FILTERS : DBQUOTE 'filters' DBQUOTE;
FILTER : DBQUOTE 'filter' DBQUOTE;
SETTINGS : DBQUOTE 'settings' DBQUOTE;
INDICES : DBQUOTE 'indices' DBQUOTE;
INDEX : DBQUOTE 'index' DBQUOTE;
SOURCES : DBQUOTE 'sources' DBQUOTE;
SOURCE1 : DBQUOTE '_source' DBQUOTE;
SOURCE2 : DBQUOTE 'source' DBQUOTE;
TYPE1 : DBQUOTE '_type' DBQUOTE;
TYPE2 : DBQUOTE 'type' DBQUOTE;
CLASS : DBQUOTE 'class' DBQUOTE;
COMMON : DBQUOTE 'common' DBQUOTE;
MATCH_ALL : DBQUOTE 'match_all' DBQUOTE;
MATCH_NONE : DBQUOTE 'match_none' DBQUOTE;
MULTI_MATCH : DBQUOTE 'multi_match' DBQUOTE;
COMBINED_FIELDS : DBQUOTE 'combined_fields' DBQUOTE;
MATCH_PHRASE_PREFIX : DBQUOTE 'match_phrase_prefix' DBQUOTE;
MATCH_PHRASE : DBQUOTE 'match_phrase' DBQUOTE;
MATCH_BOOL_PREFIX : DBQUOTE 'match_bool_prefix' DBQUOTE;
MATCH : DBQUOTE 'match' DBQUOTE;
AGGREGATIONS :  DBQUOTE 'aggregations' DBQUOTE;
AGGS : DBQUOTE 'aggs' DBQUOTE;
AGG : DBQUOTE 'agg' DBQUOTE;
INCLUDES : DBQUOTE 'includes' DBQUOTE;
EXCLUDES : DBQUOTE 'excludes' DBQUOTE;
SOURCE_INCLUDE : DBQUOTE 'source_include' DBQUOTE;
SOURCE_EXCLUDE : DBQUOTE 'source_exclude' DBQUOTE;
INCLUDE : DBQUOTE 'include' DBQUOTE;
EXCLUDE : DBQUOTE 'exclude' DBQUOTE;
RUNTIME_MAPPINGS : DBQUOTE '_runtime_mappings' DBQUOTE;
RUNTIME_MAPPINGS1 : DBQUOTE 'runtime_mappings' DBQUOTE;
MAPPINGS1 : DBQUOTE '_mappings' DBQUOTE;
MAPPINGS2 : DBQUOTE 'mappings' DBQUOTE;
PROPERTIES : DBQUOTE 'properties' DBQUOTE;
LANG : DBQUOTE 'lang' DBQUOTE;
IGNORED : DBQUOTE '_ignore' DBQUOTE;
META : DBQUOTE '_meta' DBQUOTE;
ID1 : DBQUOTE '_id' DBQUOTE;
ID2 : DBQUOTE 'id' DBQUOTE;
SORT : DBQUOTE 'sort' DBQUOTE;
TERMS_SET : DBQUOTE 'terms_set' DBQUOTE;
TERMS : DBQUOTE 'terms' DBQUOTE;
TERM : DBQUOTE 'term' DBQUOTE;
DYNAMIC : DBQUOTE 'dynamic' DBQUOTE;
FORMAT :  DBQUOTE 'format' DBQUOTE;
PREFIX : DBQUOTE 'prefix' DBQUOTE;
REGEXP : DBQUOTE 'regexp' DBQUOTE;
WILDCARD : DBQUOTE 'wildcard' DBQUOTE;
GEO_BOUNDING_BOX : DBQUOTE 'geo_bounding_box' DBQUOTE;
GEO_DISTANCE : DBQUOTE 'geo_distance' DBQUOTE;
GEO_POLYGON : DBQUOTE 'geo_polygon' DBQUOTE;
GEO_SHAPE : DBQUOTE 'geo_shape' DBQUOTE;
DISTANCE_TYPE : DBQUOTE 'distance_type' DBQUOTE;
DISTANCE : DBQUOTE 'distance' DBQUOTE;
NAME1 : DBQUOTE '_name' DBQUOTE;
VALIDATION_METHOD : DBQUOTE 'validation_method' DBQUOTE;
SHAPE : DBQUOTE 'shape' DBQUOTE;
SPAN_NEAR : DBQUOTE 'span_near' DBQUOTE;
SPAN_NOT :DBQUOTE 'span_not' DBQUOTE;
SPAN_OR : DBQUOTE 'span_or' DBQUOTE;
SPAN_AND : DBQUOTE 'span_and' DBQUOTE;
SPAN_TERM : DBQUOTE 'span_term' DBQUOTE;
SPAN_CONTAINING : DBQUOTE 'span_containing' DBQUOTE;
SPAN_FIELD_MASKING : DBQUOTE 'span_field_masking' DBQUOTE;
SPAN_FIRST : DBQUOTE 'span_first' DBQUOTE;
SPAN_MULTI : DBQUOTE 'span_multi' DBQUOTE;
SPAN_WITHIN : DBQUOTE 'span_within' DBQUOTE;
CLAUSES :  DBQUOTE 'clauses' DBQUOTE;
BOOL : DBQUOTE 'bool' DBQUOTE;
ADJACENCY_MATRIX : DBQUOTE 'adjacency_matrix' DBQUOTE;
AUTO_DATE_HISTOGRAM : DBQUOTE 'auto_date_histogram' DBQUOTE;
DATE_HISTOGRAM : DBQUOTE 'date_histogram' DBQUOTE;
HISTOGRAM : DBQUOTE 'histogram' DBQUOTE;
CATEGORY_TEXT : DBQUOTE 'categorize_text' DBQUOTE;
CHILDREN : DBQUOTE 'children' DBQUOTE;
COMPOSITE : DBQUOTE 'composite' DBQUOTE;
DATE_RANGE : DBQUOTE 'date_range' DBQUOTE;
DIVERSIFIED_SAMPLER : DBQUOTE 'diversified_sampler' DBQUOTE;
GEO_HASH_GRID : DBQUOTE 'geohash_grid' DBQUOTE;
GEO_TILE_GRID : DBQUOTE 'geotile_grid' DBQUOTE;
IP_RANGE : DBQUOTE 'ip_range' DBQUOTE;
MISSING : DBQUOTE 'missing' DBQUOTE;
MULTI_TERMS : DBQUOTE 'multi_terms' DBQUOTE;
PARENT : DBQUOTE 'parent' DBQUOTE;
RANGE : DBQUOTE 'range' DBQUOTE;
GT : DBQUOTE 'gt' DBQUOTE;
GTE : DBQUOTE 'gte' DBQUOTE;
LT : DBQUOTE 'lt' DBQUOTE;
LTE : DBQUOTE 'lte' DBQUOTE;
RARE_TERMS : DBQUOTE 'rare_terms' DBQUOTE;
SAMPLER : DBQUOTE 'sampler' DBQUOTE;
SIGNIFICANT_CRIME_TYPES : DBQUOTE 'significant_crime_types' DBQUOTE;
SIGNIFICANT_TEXT : DBQUOTE 'significant_text' DBQUOTE;
VARIABLE_WIDTH_HSITOGRAM : DBQUOTE 'variable_width_histogram' DBQUOTE;
PARAMETERS : DBQUOTE 'parameters' DBQUOTE;
AVG : DBQUOTE 'avg' DBQUOTE;
BOXPLOT : DBQUOTE 'boxplot' DBQUOTE;
CARDINALITY : DBQUOTE 'cardinality' DBQUOTE;
EXTENDED_STATS : DBQUOTE 'extended_stats' DBQUOTE;
GEO_BOUNDS : DBQUOTE 'geo_bounds' DBQUOTE;
GEO_CENTROID : DBQUOTE 'geo_centroid' DBQUOTE;
GEO_LINE : DBQUOTE 'geo_line' DBQUOTE;
MATRIX_STATS : DBQUOTE 'matrix_stats' DBQUOTE;
MAX : DBQUOTE 'max' DBQUOTE;
MIN : DBQUOTE 'min' DBQUOTE;
MEDIAN_ABSOLUTE_DEVIATION : DBQUOTE 'median_absolute_deviation' DBQUOTE;
PERCENTILE_RANKS : DBQUOTE 'percentile_ranks' DBQUOTE;
PERCENTILES : DBQUOTE 'percentiles' DBQUOTE;
RATE : DBQUOTE 'rate' DBQUOTE;
SCRIPTED_METRIC : DBQUOTE 'scripted_metric' DBQUOTE;
STRING_STATS : DBQUOTE 'string_stats' DBQUOTE;
STATS : DBQUOTE 'stats' DBQUOTE;
SUM : DBQUOTE 'sum' DBQUOTE;
T_TEST : DBQUOTE 't_test' DBQUOTE;
TOP_HITS : DBQUOTE 'top_hits' DBQUOTE;
TOP_METRICS : DBQUOTE 'top_metrics' DBQUOTE;
METRICS : DBQUOTE 'metrics' DBQUOTE;
TYPES_COUNT : DBQUOTE 'types_count' DBQUOTE;
WEIGHTED_AVG : DBQUOTE 'weighted_avg' DBQUOTE;
WEIGHT : DBQUOTE 'weight' DBQUOTE;
INFERENCE : DBQUOTE 'inference' DBQUOTE;
AVERAGE_BUCKET : DBQUOTE 'avg_bucket' DBQUOTE;
BUCKET_SCRIPT : DBQUOTE 'bucket_script' DBQUOTE;
BUCKET_COUNT_KS_TEST : DBQUOTE 'bucket_count_ks_test' DBQUOTE;
BUCKET_CORRELATION : DBQUOTE 'bucket_correlation' DBQUOTE;
BUCKET_SELECTOR : DBQUOTE 'bucket_selector' DBQUOTE;
BUCKET_SORT : DBQUOTE 'bucket_sort' DBQUOTE;
CUMULATIVE_CARDINALITY : DBQUOTE 'cumulative_cardinality' DBQUOTE;
CUMULATIVE_SUM : DBQUOTE 'cumulative_sum' DBQUOTE;
DERIVATIVE : DBQUOTE 'derivative' DBQUOTE;
EXTENDED_STATS_BUCKET : DBQUOTE 'extended_stats_bucket' DBQUOTE;
MAX_BUCKET : DBQUOTE 'max_bucket' DBQUOTE;
MIN_BUCKET : DBQUOTE 'min_bucket' DBQUOTE;
MOVING_AVG : DBQUOTE 'moving_avg' DBQUOTE;
MOMVING_FN : DBQUOTE 'moving_fn' DBQUOTE;
MOMVING_PERCENTILES : DBQUOTE 'moving_percentiles' DBQUOTE;
NORMALIZE : DBQUOTE 'normalize' DBQUOTE;
PERCENTILES_BUCKET : DBQUOTE 'percentiles_bucket' DBQUOTE;
SERIAL_DIFF : DBQUOTE 'serial_diff' DBQUOTE;
STATS_BUCKET : DBQUOTE 'stats_bucket' DBQUOTE;
SUM_BUCKET : DBQUOTE 'sum_bucket' DBQUOTE;
STRING1 : DBQUOTE 'string' DBQUOTE;
INDEX_FILTER : DBQUOTE 'index_filter' DBQUOTE;
REQUESTS : DBQUOTE 'requests' DBQUOTE;
REQUEST : DBQUOTE 'request' DBQUOTE;
RATINGS : DBQUOTE 'ratings' DBQUOTE;
BOOSTING : DBQUOTE 'boosting' DBQUOTE;
CONSTANT_SCORE : DBQUOTE 'constant_score' DBQUOTE;
DIS_MAX : DBQUOTE 'dis_max' DBQUOTE;
QUERIES : DBQUOTE 'queries' DBQUOTE;
FUNCTION_SCORE : DBQUOTE 'function_score' DBQUOTE;
DEFAULT_FIELD : DBQUOTE 'default_field' DBQUOTE;
HAS_CHILD : DBQUOTE 'has_child' DBQUOTE;
HAS_PARENT : DBQUOTE 'has_parent' DBQUOTE;
PARENT_ID : DBQUOTE 'parent_id' DBQUOTE;
DISTANCE_FEATURE : DBQUOTE 'distance_feature' DBQUOTE;
MORE_LIKE_THIS : DBQUOTE 'more_like_this' DBQUOTE;
LIKE : DBQUOTE 'like' DBQUOTE;
UNLIKE : DBQUOTE 'unlike' DBQUOTE;
PERCOLATE : DBQUOTE 'percolate' DBQUOTE;
DOCUMENTS : DBQUOTE 'documents' DBQUOTE;
DOCUMENT : DBQUOTE 'document' DBQUOTE;
RANK_FEATURE : DBQUOTE 'rank_feature' DBQUOTE;
PINNED : DBQUOTE 'pinned' DBQUOTE;
ORGANIC : DBQUOTE 'organic' DBQUOTE;
SIGNIFICANT_TERMS : DBQUOTE 'significant_terms' DBQUOTE;
BACKGROUND_FILTER : DBQUOTE 'background_filter' DBQUOTE;
SOURCE_FIELDS : DBQUOTE 'source_fields' DBQUOTE;
PATTERN : DBQUOTE 'pattern' DBQUOTE;
INDICES_BOOST : DBQUOTE 'indices_boost' DBQUOTE;
INTERVALS : DBQUOTE 'intervals' DBQUOTE;
ANYOF : DBQUOTE 'any_of' DBQUOTE;
ALLOF : DBQUOTE 'all_of' DBQUOTE;
USE_FIELD : DBQUOTE 'use_field' DBQUOTE;
ALIASES : DBQUOTE 'aliases' DBQUOTE;
DYNAMIC_TEMPLATES : DBQUOTE 'dynamic_templates' DBQUOTE;
DEFINE_ALL : DBQUOTE '_all' DBQUOTE;


//response part
//_search response
HITS : DBQUOTE 'hits' DBQUOTE;

URI_QUESTION: '?' -> pushMode(URI_FRAGMENT),skip;
FREE_STRING_BEGIN : '"""' -> pushMode(FREE_STRING);

STRING  :  ( '"' (ESC | SAFECODEPOINT)* '"')
           |(FREE_STRING_BEGIN ([\r\n\t "]| ESC | SAFECODEPOINT)* (FREE_STRING_BEGIN|FREE_STRING_END))
           ;

NUMBER : '-'? INT ('.' [0-9] +)? EXP? ;
PID : PATH_ID;
CID : ID;
WS : [ \t\n\r,] + -> skip ;

fragment PATH_ID : ([a-zA-Z0-9])([a-zA-Z0-9_-]|'.'|'*')*;
fragment AND : '&';
fragment STAR : '*';
fragment DOT : '.';
fragment ID : ([a-zA-Z_0-9]|'.'|'*')([a-zA-Z0-9_-]|'.'|'*')*;
fragment PERCENT : '%';
fragment ESC : '\\' (["\\/bfnrt] | UNICODE) ;
fragment UNICODE : 'u' HEX HEX HEX HEX ;
fragment HEX : [0-9a-fA-F] ;
fragment SAFECODEPOINT : ~ ["\\\u0000-\u001F] ;
fragment DBQUOTE:'"' ;
fragment INT : '0' | [1-9] [0-9]* ;
fragment EXP : [Ee] [+\-]? INT ;

mode FREE_STRING;
    FREE_STRING_ESC : [\r\n\t ];
    FREE_STRING_END : '"""' -> popMode;

mode URI_FRAGMENT;
    URI_SIGN: '+'|'-'|'%'|','|'='|'.';
    URI_EQ : '=';
    URI_AND : '&';
    URI_ID : [a-zA-Z0-9,._]+;
    URI_WS:  [ \r\n]+ -> popMode,skip;
