package com.chenyang.druid.sql.dialect.es.visitor;

import com.chenyang.druid.sql.dialect.es.ast.EsParser;
import com.chenyang.druid.sql.dialect.es.ast.EsParserContextBase;
import java.util.List;

public class QueryResponseVisitor {
   private final Visitor visitor;

   public QueryResponseVisitor(Visitor visitor) {
      this.visitor = visitor;
   }

   public void accept(EsParser.SearchResponseContext ctx) {
      this.visitor.setStatement(ctx);
      EsParser.SearchResponseItemContext searchResponseItemContext = ctx.searchResponseItem();

      for(EsParser.SearchResponseItemHitsContext itemHits : searchResponseItemContext.searchResponseItemHits()) {
         for(EsParser.SearchResponseHitsHitsContext datasCtx : itemHits.searchResponseHitsHits()) {
            for(EsParser.SearchResponseHitsHitsMemoContext dataCtx : datasCtx.searchResponseHitsHitsMemo()) {
               boolean result = this.visitor.acceptDataItem(dataCtx);
               if (!result) {
                  break;
               }
            }

            List<EsParser.SearchResponseHitsHitsFieldsContext> fieldsDataCtx = datasCtx.searchResponseHitsHitsFields();
            if (fieldsDataCtx != null && fieldsDataCtx.size() > 0) {
               for(EsParser.SearchResponseHitsHitsFieldsContext fieldDatasCtx : fieldsDataCtx) {
                  this.visitor.acceptFieldsDataItems(fieldDatasCtx);
               }
            }
         }

         List<EsParser.SearchResponseItemAgregationsContext> aggregations = searchResponseItemContext.searchResponseItemAgregations();
         if (aggregations != null) {
            for(EsParser.SearchResponseItemAgregationsContext aggregation : aggregations) {
               this.visitor.acceptAregations(aggregation);
            }
         }
      }

   }

   public void accept(EsParser.GetResponseContext ctx) {
      this.visitor.setStatement(ctx);
      EsParser.SearchResponseHitsHitsMemoContext searchResponseItemContext = ctx.searchResponseHitsHitsMemo();
      this.visitor.acceptDataItem(searchResponseItemContext);
   }

   public interface Visitor {
      void setStatement(EsParserContextBase var1);

      EsParserContextBase getStatement();

      boolean acceptDataItem(EsParser.SearchResponseHitsHitsMemoContext var1);

      boolean acceptFieldsDataItems(EsParser.SearchResponseHitsHitsFieldsContext var1);

      boolean acceptAregations(EsParser.SearchResponseItemAgregationsContext var1);
   }
}
