package com.chenyang.druid.sql.dialect.gauss.ast.expr;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.dialect.gauss.ast.GaussSQLObjectImpl;
import com.chenyang.druid.sql.dialect.gauss.visitor.GaussASTVisitor;
import util.sqlparse.visitor.common.Objects;

public class GaussColumnSimpleDefinitionExpr extends GaussSQLObjectImpl {
   private SQLName name;
   private SQLExpr type;

   public SQLName getName() {
      return this.name;
   }

   public void setName(SQLName name) {
      this.name = name;
      name.setParent(this);
   }

   public SQLExpr getType() {
      return this.type;
   }

   public void setType(SQLExpr type) {
      this.type = type;
      if (type != null) {
         type.setParent(this);
      }

   }

   public void accept0(GaussASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.name);
         this.acceptChild(visitor, this.type);
      }

      visitor.endVisit(this);
   }

   public GaussColumnSimpleDefinitionExpr clone() {
      GaussColumnSimpleDefinitionExpr e = new GaussColumnSimpleDefinitionExpr();
      e.name = this.name.clone();
      if (this.type != null) {
         e.type = this.type.clone();
      }

      return e;
   }

   public boolean equals(Object o) {
      if (this == o) {
         return true;
      } else if (o != null && this.getClass() == o.getClass()) {
         GaussColumnSimpleDefinitionExpr that = (GaussColumnSimpleDefinitionExpr)o;
         if (this.name == null && that.name != null) {
            return false;
         } else if (this.type == null && that.type != null) {
            return false;
         } else {
            return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type);
         }
      } else {
         return false;
      }
   }

   public int hashCode() {
      int prime = 31;
      int result = 31 * this.name.hashCode();
      if (this.type != null) {
         result = prime * result + this.type.hashCode();
      }

      return result;
   }
}
