package com.chenyang.druid.sql.dialect.gauss.ast.expr;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.SQLReplaceable;
import com.chenyang.druid.sql.dialect.gauss.visitor.GaussASTVisitor;
import java.util.Collections;
import java.util.List;

public class GaussExtractExpr extends GaussExprImpl implements SQLReplaceable {
   private GaussDateField field;
   private SQLExpr source;

   public GaussExtractExpr clone() {
      GaussExtractExpr x = new GaussExtractExpr();
      x.field = this.field;
      if (this.source != null) {
         x.setSource(this.source.clone());
      }

      return x;
   }

   public GaussDateField getField() {
      return this.field;
   }

   public void setField(GaussDateField field) {
      this.field = field;
   }

   public SQLExpr getSource() {
      return this.source;
   }

   public void setSource(SQLExpr source) {
      if (source != null) {
         source.setParent(this);
      }

      this.source = source;
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      if (this.source == expr) {
         this.setSource(target);
         return true;
      } else {
         return false;
      }
   }

   public void accept0(GaussASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.source);
      }

      visitor.endVisit(this);
   }

   public List<SQLObject> getChildren() {
      return Collections.singletonList(this.source);
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.field == null ? 0 : this.field.hashCode());
      result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         GaussExtractExpr other = (GaussExtractExpr)obj;
         if (this.field != other.field) {
            return false;
         } else {
            if (this.source == null) {
               if (other.source != null) {
                  return false;
               }
            } else if (!this.source.equals(other.source)) {
               return false;
            }

            return true;
         }
      }
   }
}
