package com.chenyang.druid.sql.dialect.gauss.ast.stmt;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.statement.SQLCreateDatabaseStatement;
import com.chenyang.druid.sql.dialect.gauss.ast.GaussSQLObject;
import com.chenyang.druid.sql.dialect.gauss.visitor.GaussASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class GaussCreateDatabaseStatement extends SQLCreateDatabaseStatement implements GaussSQLObject {
   private SQLExpr owner;
   private SQLExpr template;
   private SQLExpr encoding;
   private SQLExpr lcCollate;
   private SQLExpr ctype;
   private SQLExpr tablespace;
   private SQLExpr limit;

   public GaussCreateDatabaseStatement() {
      this.dbType = DbType.gauss;
   }

   public SQLExpr getOwner() {
      return this.owner;
   }

   public void setOwner(SQLExpr owner) {
      this.owner = owner;
      owner.setParent(this);
   }

   public SQLExpr getTemplate() {
      return this.template;
   }

   public void setTemplate(SQLExpr template) {
      this.template = template;
      template.setParent(this);
   }

   public SQLExpr getEncoding() {
      return this.encoding;
   }

   public void setEncoding(SQLExpr encoding) {
      this.encoding = encoding;
      encoding.setParent(this);
   }

   public SQLExpr getLcCollate() {
      return this.lcCollate;
   }

   public void setLcCollate(SQLExpr lcCollate) {
      this.lcCollate = lcCollate;
      lcCollate.setParent(this);
   }

   public SQLExpr getCtype() {
      return this.ctype;
   }

   public void setCtype(SQLExpr ctype) {
      this.ctype = ctype;
      ctype.setParent(this);
   }

   public SQLExpr getTablespace() {
      return this.tablespace;
   }

   public void setTablespace(SQLExpr tablespace) {
      this.tablespace = tablespace;
      tablespace.setParent(this);
   }

   public SQLExpr getLimit() {
      return this.limit;
   }

   public void setLimit(SQLExpr limit) {
      this.limit = limit;
      limit.setParent(this);
   }

   public void accept0(SQLASTVisitor visitor) {
      this.accept0((GaussASTVisitor)visitor);
   }

   public void accept0(GaussASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.owner);
         this.acceptChild(visitor, this.template);
         this.acceptChild(visitor, this.encoding);
         this.acceptChild(visitor, this.lcCollate);
         this.acceptChild(visitor, this.ctype);
         this.acceptChild(visitor, this.tablespace);
         this.acceptChild(visitor, this.limit);
      }

      visitor.endVisit(this);
   }

   public GaussCreateDatabaseStatement clone() {
      GaussCreateDatabaseStatement c = new GaussCreateDatabaseStatement();
      if (this.owner != null) {
         c.setOwner(this.owner.clone());
      }

      if (this.template != null) {
         c.setTemplate(this.template.clone());
      }

      if (this.encoding != null) {
         c.setEncoding(this.encoding.clone());
      }

      if (this.lcCollate != null) {
         c.setLcCollate(this.lcCollate.clone());
      }

      if (this.ctype != null) {
         c.setCtype(this.ctype.clone());
      }

      if (this.tablespace != null) {
         c.setTablespace(this.tablespace.clone());
      }

      if (this.limit != null) {
         c.setLimit(this.limit.clone());
      }

      return c;
   }
}
