package com.chenyang.druid.sql.dialect.gauss.ast.stmt;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.statement.SQLSelect;
import com.chenyang.druid.sql.ast.statement.SQLSelectStatement;
import com.chenyang.druid.sql.dialect.gauss.visitor.GaussASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class GaussSelectStatement extends SQLSelectStatement implements GaussSQLStatement {
   public GaussSelectStatement() {
      super(DbType.gauss);
   }

   public GaussSelectStatement(SQLSelect select) {
      super(select, DbType.gauss);
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof GaussASTVisitor) {
         this.accept0((GaussASTVisitor)visitor);
      } else {
         super.accept0(visitor);
      }

   }

   public void accept0(GaussASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.select);
      }

      visitor.endVisit(this);
   }
}
