package com.chenyang.druid.sql.dialect.gauss.ast.stmt.alterTable;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.statement.SQLAlterTableItem;
import com.chenyang.druid.sql.dialect.gauss.ast.GaussSQLObjectImpl;
import com.chenyang.druid.sql.dialect.gauss.visitor.GaussASTVisitor;

public class GaussAlterTableSetSchema extends GaussSQLObjectImpl implements SQLAlterTableItem {
   private SQLExpr schema;

   public void accept0(GaussASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.schema);
      }

      visitor.endVisit(this);
   }

   public SQLExpr getSchema() {
      return this.schema;
   }

   public void setSchema(SQLExpr schema) {
      schema.setParent(this);
      this.schema = schema;
   }

   public GaussAlterTableSetSchema clone() {
      GaussAlterTableSetSchema c = new GaussAlterTableSetSchema();
      c.setSchema(this.schema.clone());
      return c;
   }
}
