package com.chenyang.druid.sql.dialect.gauss.ast.stmt.alterTable;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.statement.SQLAlterTableItem;
import com.chenyang.druid.sql.dialect.gauss.ast.GaussSQLObjectImpl;
import com.chenyang.druid.sql.dialect.gauss.visitor.GaussASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class GaussAlterTableSetWith extends GaussSQLObjectImpl implements SQLAlterTableItem {
   private boolean withReorgnize = false;
   private DistributeType distributeType;
   private List<GaussAlterTableDistributeByOption> options = new ArrayList();

   public boolean isWithReorgnize() {
      return this.withReorgnize;
   }

   public void setWithReorgnize(boolean withReorgnize) {
      this.withReorgnize = withReorgnize;
   }

   public DistributeType getDistributeType() {
      return this.distributeType;
   }

   public void setDistributeType(DistributeType distributeType) {
      this.distributeType = distributeType;
   }

   public List<GaussAlterTableDistributeByOption> getOptions() {
      return this.options;
   }

   public void setOptions(List<GaussAlterTableDistributeByOption> options) {
      this.options = options;
   }

   public void addOption(GaussAlterTableDistributeByOption option) {
      this.options.add(option);
      option.setParent(this);
   }

   public void accept0(GaussASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.options);
      }

      visitor.endVisit(this);
   }

   public GaussAlterTableSetWith clone() {
      GaussAlterTableSetWith c = new GaussAlterTableSetWith();
      c.distributeType = this.distributeType;
      c.withReorgnize = this.withReorgnize;
      if (this.options != null && this.options.size() > 0) {
         for(GaussAlterTableDistributeByOption option : this.options) {
            c.addOption(option.clone());
         }
      }

      return c;
   }

   public static class GaussAlterTableDistributeByOption extends GaussSQLObjectImpl {
      private SQLExpr columnName;
      private SQLExpr opClass;

      public SQLExpr getColumnName() {
         return this.columnName;
      }

      public void setColumnName(SQLExpr columnName) {
         columnName.setParent(this);
         this.columnName = columnName;
      }

      public SQLExpr getOpClass() {
         return this.opClass;
      }

      public void setOpClass(SQLExpr opClass) {
         opClass.setParent(this);
         this.opClass = opClass;
      }

      public void accept0(SQLASTVisitor visitor) {
         this.accept0((GaussASTVisitor)visitor);
      }

      public void accept0(GaussASTVisitor visitor) {
         if (visitor.visit(this)) {
            if (this.columnName != null) {
               this.columnName.accept(visitor);
            }

            if (this.opClass != null) {
               this.opClass.accept(visitor);
            }
         }

         visitor.endVisit(this);
      }

      public GaussAlterTableDistributeByOption clone() {
         GaussAlterTableDistributeByOption o = new GaussAlterTableDistributeByOption();
         o.setColumnName(this.columnName.clone());
         if (this.opClass != null) {
            o.setOpClass(this.opClass.clone());
         }

         return o;
      }
   }

   public static enum DistributeType {
      with,
      by,
      randomly,
      replicated;
   }
}
